/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromSubquery
extends FromTable {
    ResultSetNode subquery;
    private SchemaDescriptor origCompilationSchema = null;

    public void init(Object subquery, Object correlationName, Object derivedRCL, Object tableProperties) {
        super.init(correlationName, tableProperties);
        this.subquery = (ResultSetNode)subquery;
        this.resultColumns = (ResultColumnList)derivedRCL;
    }

    public String toString() {
        return super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquery != null) {
            this.printLabel(depth, "subquery: ");
            this.subquery.treePrint(depth + 1);
        }
    }

    public ResultSetNode getSubquery() {
        return this.subquery;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return super.getFromTableByName(name, schemaName, exactMatch);
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromListParam);
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromListParam);
        return this;
    }

    public void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindExpressions(FromList fromListParam) throws StandardException {
        FromList emptyFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList derivedRCL = this.resultColumns;
        FromList nestedFromList = emptyFromList;
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.origCompilationSchema != null) {
            compilerContext.pushCompilationSchema(this.origCompilationSchema);
        }
        try {
            this.subquery.bindExpressions(nestedFromList);
            this.subquery.bindResultColumns(nestedFromList);
        }
        finally {
            if (this.origCompilationSchema != null) {
                compilerContext.popCompilationSchema();
            }
        }
        ResultColumnList subqueryRCL = this.subquery.getResultColumns();
        if (this.resultColumns != null && this.resultColumns.getCountMismatchAllowed() && this.resultColumns.size() < subqueryRCL.size()) {
            for (int index = subqueryRCL.size() - 1; index >= this.resultColumns.size(); --index) {
                subqueryRCL.removeElementAt(index);
            }
        }
        this.subquery.setResultColumns(subqueryRCL.copyListAndObjects());
        subqueryRCL.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.resultColumns = subqueryRCL;
        if (derivedRCL != null) {
            this.resultColumns.propagateDCLInfo(derivedRCL, this.correlationName);
        }
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String columnsTableName = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
        } else if (columnsTableName == null || columnsTableName.equals(this.correlationName)) {
            resultColumn = this.resultColumns.getAtMostOneResultColumn(columnReference, this.correlationName, false);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.subquery = this.subquery.preprocess(numTables, gbl, fromList);
        if ((gbl == null || gbl.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(numTables);
    }

    public ResultSetNode extractSubquery(int numTables) throws StandardException {
        ResultSetNode newPRN = (ResultSetNode)this.getNodeFactory().getNode(151, this.subquery, this.resultColumns, null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet newJBS = new JBitSet(numTables);
        newJBS.set(this.tableNumber);
        newPRN.setReferencedTableMap(newJBS);
        ((FromTable)newPRN).setTableNumber(this.tableNumber);
        return newPRN;
    }

    public FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl) throws StandardException {
        FromList fromList = null;
        this.resultColumns.setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                outerPList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                sql.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT("subquery expected to be either a SelectNode or a RowResultSetNode, but is a " + this.subquery.getClass().getName());
        }
        rcl.remapColumnReferencesToExpressions();
        outerPList.remapColumnReferencesToExpressions();
        if (gbl != null) {
            gbl.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    public String getExposedName() {
        return this.correlationName;
    }

    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.makeTableName(null, this.correlationName);
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(index);
            if (resultColumn.isGenerated()) continue;
            String columnName = resultColumn.getName();
            boolean isNameGenerated = resultColumn.isNameGenerated();
            TableName tableName = exposedName;
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, tableName, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            resultColumn.setNameGenerated(isNameGenerated);
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        this.subquery.disablePrivilegeCollection();
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.subquery.referencesTarget(name, baseTable);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(bindingRCL);
    }

    void decrementLevel(int decrement) {
        super.decrementLevel(decrement);
        this.subquery.decrementLevel(decrement);
    }

    public void setOrigCompilationSchema(SchemaDescriptor sd) {
        this.origCompilationSchema = sd;
    }
}

