/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

public class ScrollInsensitiveResultSetNode
extends SingleChildResultSetNode {
    public void init(Object childResult, Object rcl, Object tableProperties) {
        this.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)rcl;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.resultColumns != null, "Tree structure bad");
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int erdNumber = acb.addItem(this.makeResultDescription());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.resultSetNumber);
        mb.push(this.resultColumns.size());
        mb.pushThis();
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getScrollable", "boolean", 0);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getScrollInsensitiveResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 7);
    }
}

