/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class XMLTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isXMLTypeId();
    }

    public boolean compatible(TypeId otherType) {
        return otherType.isXMLTypeId();
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isXMLTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.XMLDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        if (formatId == 456) {
            return "org.apache.derby.iapi.types.XML";
        }
        SanityManager.THROWASSERT("unexpected formatId in getCorrespondingPrimitiveTypeName(): " + formatId);
        return null;
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return -1;
    }

    String nullMethodName() {
        if (this.getStoredFormatIdFromTypeId() != 456) {
            SanityManager.THROWASSERT("unexpected formatId in nullMethodName(): " + this.getStoredFormatIdFromTypeId());
        }
        return "getNullXML";
    }

    protected String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        if (formatId == 456) {
            return "getXMLDataValue";
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }
}

