/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DDUtils;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class CreateConstraintConstantAction
extends ConstraintConstantAction {
    private final boolean forCreateTable;
    private String[] columnNames;
    private String constraintText;
    private ConstraintInfo otherConstraintInfo;
    private ClassFactory cf;
    private boolean enabled;
    private ProviderInfo[] providerInfo;

    CreateConstraintConstantAction(String constraintName, int constraintType, boolean forCreateTable, String tableName, UUID tableId, String schemaName, String[] columnNames, IndexConstantAction indexAction, String constraintText, boolean enabled, ConstraintInfo otherConstraint, ProviderInfo[] providerInfo) {
        super(constraintName, constraintType, tableName, tableId, schemaName, indexAction);
        this.forCreateTable = forCreateTable;
        this.columnNames = columnNames;
        this.constraintText = constraintText;
        this.enabled = enabled;
        this.otherConstraintInfo = otherConstraint;
        this.providerInfo = providerInfo;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        ConglomerateDescriptor conglomDesc = null;
        ConglomerateDescriptor[] conglomDescs = null;
        ConstraintDescriptor conDesc = null;
        TableDescriptor td = null;
        UUID indexId = null;
        if (this.constraintType == 1) {
            return;
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        this.cf = lcc.getLanguageConnectionFactory().getClassFactory();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd, tc);
            if (td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            activation.setDDLTableDescriptor(td);
        }
        UUIDFactory uuidFactory = dd.getUUIDFactory();
        if (this.indexAction != null) {
            String backingIndexName;
            if (this.indexAction.getIndexName() == null) {
                backingIndexName = uuidFactory.createUUID().toString();
                this.indexAction.setIndexName(backingIndexName);
            } else {
                backingIndexName = this.indexAction.getIndexName();
            }
            this.indexAction.executeConstantAction(activation);
            conglomDescs = td.getConglomerateDescriptors();
            for (int index = 0; !(index >= conglomDescs.length || (conglomDesc = conglomDescs[index]).isIndex() && backingIndexName.equals(conglomDesc.getConglomerateName())); ++index) {
            }
            SanityManager.ASSERT(conglomDesc != null, "conglomDesc is expected to be non-null after search for backing index");
            SanityManager.ASSERT(conglomDesc.isIndex(), "conglomDesc is expected to be indexable after search for backing index");
            SanityManager.ASSERT(conglomDesc.getConglomerateName().equals(backingIndexName), "conglomDesc name expected to be the same as backing index name after search for backing index");
            indexId = conglomDesc.getUUID();
        }
        UUID constraintId = uuidFactory.createUUID();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        switch (this.constraintType) {
            case 2: {
                conDesc = ddg.newPrimaryKeyConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, this.enabled, 0);
                dd.addConstraintDescriptor(conDesc, tc);
                break;
            }
            case 3: {
                conDesc = ddg.newUniqueConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, this.enabled, 0);
                dd.addConstraintDescriptor(conDesc, tc);
                break;
            }
            case 4: {
                conDesc = ddg.newCheckConstraintDescriptor(td, this.constraintName, false, false, constraintId, this.constraintText, new ReferencedColumnsDescriptorImpl(this.genColumnPositions(td, false)), sd, this.enabled);
                dd.addConstraintDescriptor(conDesc, tc);
                this.storeConstraintDependenciesOnPrivileges(activation, conDesc, null, this.providerInfo);
                break;
            }
            case 6: {
                ReferencedKeyConstraintDescriptor referencedConstraint = DDUtils.locateReferencedConstraint(dd, td, this.constraintName, this.columnNames, this.otherConstraintInfo);
                DDUtils.validateReferentialActions(dd, td, this.constraintName, this.otherConstraintInfo, this.columnNames);
                conDesc = ddg.newForeignKeyConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, referencedConstraint, this.enabled, this.otherConstraintInfo.getReferentialActionDeleteRule(), this.otherConstraintInfo.getReferentialActionUpdateRule());
                dd.addConstraintDescriptor(conDesc, tc);
                if (!this.forCreateTable && dd.activeConstraint(conDesc)) {
                    CreateConstraintConstantAction.validateFKConstraint(tc, dd, (ForeignKeyConstraintDescriptor)conDesc, referencedConstraint, ((CreateIndexConstantAction)this.indexAction).getIndexTemplateRow());
                }
                dm.addDependency(conDesc, referencedConstraint, lcc.getContextManager());
                this.storeConstraintDependenciesOnPrivileges(activation, conDesc, referencedConstraint.getTableId(), this.providerInfo);
                break;
            }
            default: {
                SanityManager.THROWASSERT("contraintType (" + this.constraintType + ") has unexpected value");
            }
        }
        if (this.providerInfo != null) {
            for (int ix = 0; ix < this.providerInfo.length; ++ix) {
                Provider provider = null;
                provider = (Provider)this.providerInfo[ix].getDependableFinder().getDependable(dd, this.providerInfo[ix].getObjectId());
                dm.addDependency(conDesc, provider, lcc.getContextManager());
            }
        }
        if (!this.forCreateTable) {
            dm.invalidateFor(td, 22, lcc);
        }
        if (this.constraintType == 6) {
            SanityManager.ASSERT(conDesc != null, "conDesc expected to be non-null");
            if (!(conDesc instanceof ForeignKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT("conDesc expected to be instance of ForeignKeyConstraintDescriptor, not " + conDesc.getClass().getName());
            }
            dm.invalidateFor(((ForeignKeyConstraintDescriptor)conDesc).getReferencedConstraint().getTableDescriptor(), 22, lcc);
        }
    }

    boolean isForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    private int[] genColumnPositions(TableDescriptor td, boolean columnsMustBeOrderable) throws StandardException {
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            if (columnsMustBeOrderable && !columnDescriptor.getType().getTypeId().orderable(this.cf)) {
                throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
        }
        return baseColumnPositions;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("CREATE CONSTRAINT " + this.constraintName);
        strbuf.append("\n=========================\n");
        if (this.columnNames == null) {
            strbuf.append("columnNames == null\n");
        } else {
            for (int ix = 0; ix < this.columnNames.length; ++ix) {
                strbuf.append("\n\tcol[" + ix + "]" + this.columnNames[ix].toString());
            }
        }
        strbuf.append("\n");
        strbuf.append(this.constraintText);
        strbuf.append("\n");
        if (this.otherConstraintInfo != null) {
            strbuf.append(this.otherConstraintInfo.toString());
        }
        strbuf.append("\n");
        return strbuf.toString();
    }
}

