/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class ProjectRestrictResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    final NoPutResultSet source;
    public GeneratedMethod constantRestriction;
    public GeneratedMethod restriction;
    public boolean doesProjection;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    private boolean shortCircuitOpen;
    private ExecRow projRow;

    ProjectRestrictResultSet(NoPutResultSet s, Activation a, GeneratedMethod r, GeneratedMethod p, int resultSetNumber, GeneratedMethod cr, int mapRefItem, boolean reuseResult, boolean doesProjection, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        SanityManager.ASSERT(this.source != null, "PRRS(), source expected to be non-null");
        this.restriction = r;
        this.projection = p;
        this.constantRestriction = cr;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)a.getPreparedStatement().getSavedObject(mapRefItem)).getReferencedColumnPositions();
        this.reuseResult = reuseResult;
        this.doesProjection = doesProjection;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.source != null, "PRRS().openCore(), source expected to be non-null");
        SanityManager.ASSERT(!this.isOpen, "ProjectRestrictResultSet already open");
        if (this.constantRestriction != null) {
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl = constantEval = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (constantEval) {
            this.source.openCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "ProjectRestrictResultSet not open, cannot reopen");
        if (this.constantRestriction != null) {
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl = constantEval = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (constantEval) {
            this.source.reopenCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        long beginRT = 0L;
        if (this.shortCircuitOpen) {
            return result;
        }
        this.beginTime = this.getCurrentTimeMillis();
        do {
            if ((candidateRow = this.source.getNextRowCore()) == null) continue;
            beginRT = this.getCurrentTimeMillis();
            if (this.restriction == null) {
                restrict = true;
            } else {
                this.setCurrentRow(candidateRow);
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                this.restrictionTime += this.getElapsedMillis(beginRT);
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                }
            }
            ++this.rowsSeen;
        } while (candidateRow != null && !restrict);
        if (candidateRow != null) {
            beginRT = this.getCurrentTimeMillis();
            result = this.doProjection(candidateRow);
            this.projectionTime += this.getElapsedMillis(beginRT);
        } else {
            this.clearCurrentRow();
        }
        this.currentRow = result;
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return result;
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public void close() throws StandardException {
        if (this.shortCircuitOpen) {
            this.isOpen = false;
            this.shortCircuitOpen = false;
            this.source.close();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of ProjectRestrictResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT(this.source instanceof CursorResultSet, "source is not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        SanityManager.ASSERT(this.isOpen, "PRRS is expected to be open");
        if (this.currentRow == null) {
            return null;
        }
        candidateRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (candidateRow != null) {
            this.setCurrentRow(candidateRow);
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (candidateRow != null && restrict) {
            result = this.doProjection(candidateRow);
        }
        this.currentRow = result;
        if (result == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow sourceRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            this.setCurrentRow(this.projRow);
            return this.projRow;
        }
        ExecRow result = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        for (int index = 0; index < this.projectMapping.length; ++index) {
            if (this.projectMapping[index] == -1) continue;
            result.setColumn(index + 1, sourceRow.getColumn(this.projectMapping[index]));
        }
        this.setCurrentRow(result);
        if (this.reuseResult) {
            this.projRow = result;
        }
        return result;
    }

    public ExecRow doBaseRowProjection(ExecRow sourceRow) throws StandardException {
        ExecRow result;
        if (this.source instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet prs = (ProjectRestrictResultSet)this.source;
            result = prs.doBaseRowProjection(sourceRow);
        } else {
            result = sourceRow.getNewNullRow();
            result.setRowArray(sourceRow.getRowArray());
        }
        return this.doProjection(result);
    }

    public int[] getBaseProjectMapping() {
        int[] result;
        if (this.source instanceof ProjectRestrictResultSet) {
            result = new int[this.projectMapping.length];
            ProjectRestrictResultSet prs = (ProjectRestrictResultSet)this.source;
            int[] sourceMap = prs.getBaseProjectMapping();
            for (int i = 0; i < this.projectMapping.length; ++i) {
                if (this.projectMapping[i] <= 0) continue;
                result[i] = sourceMap[this.projectMapping[i] - 1];
            }
        } else {
            result = this.projectMapping;
        }
        return result;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public void updateRow(ExecRow row) throws StandardException {
        this.source.updateRow(row);
    }

    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

