/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.SqlXmlUtil;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;

public class SqlXmlExecutor {
    private Activation activation;
    private int sqlXUtilId;
    private int targetTypeId;
    private int targetMaxWidth;
    private int targetCollationType;
    private boolean preserveWS;

    public SqlXmlExecutor(Activation activation, int utilId, boolean preserveWS) {
        this.activation = activation;
        this.sqlXUtilId = utilId;
        this.preserveWS = preserveWS;
    }

    public SqlXmlExecutor(int targetTypeId, int targetMaxWidth, int targetCollationType) {
        this.targetTypeId = targetTypeId;
        this.targetMaxWidth = targetMaxWidth;
        this.targetCollationType = targetCollationType;
    }

    public SqlXmlExecutor(Activation activation, int utilId) {
        this.activation = activation;
        this.sqlXUtilId = utilId;
    }

    public XMLDataValue XMLParse(StringDataValue xmlText, XMLDataValue result) throws StandardException {
        if (result == null) {
            result = new XML();
        }
        if (xmlText.isNull()) {
            result.setToNull();
            return result;
        }
        return result.XMLParse(xmlText.getString(), this.preserveWS, this.getSqlXmlUtil());
    }

    public StringDataValue XMLSerialize(XMLDataValue xmlVal, StringDataValue result) throws StandardException {
        return xmlVal.XMLSerialize(result, this.targetTypeId, this.targetMaxWidth, this.targetCollationType);
    }

    public BooleanDataValue XMLExists(StringDataValue xExpr, XMLDataValue xmlContext) throws StandardException {
        return xmlContext.XMLExists(this.getSqlXmlUtil());
    }

    public XMLDataValue XMLQuery(StringDataValue xExpr, XMLDataValue xmlContext, XMLDataValue result) throws StandardException {
        return xmlContext.XMLQuery(result, this.getSqlXmlUtil());
    }

    private SqlXmlUtil getSqlXmlUtil() throws StandardException {
        return (SqlXmlUtil)this.activation.getPreparedStatement().getSavedObject(this.sqlXUtilId);
    }
}

