/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.core;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataFileHandler
extends DefaultHandler {
    private static final String ELEMENT_FILE = "file";
    private static final String ELEMENT_METADATA = "metadata";
    private static final String ATTRIBUTE_PATH = "path";
    private final boolean[] POSITION_INDICATOR = new boolean[8];
    private static final Map<String, Integer> elementIndexMap;
    private Map<String, List<String>> aliasFileMap;
    private Map<String, List<String>> fileAliasMap;
    private StringBuffer buffer;
    private String lastFile;
    private SMLIFIdentity identity;
    private Map<String, List<String>> aliasRuleBinding = new Hashtable<String, List<String>>();
    private Map<String, List<String>> ruleAliasBinding = new Hashtable<String, List<String>>();
    private StringBuffer currentRuleAliasBuffer;
    private boolean dirty;

    static {
        String[] KEYS = new String[]{"alias", "baseURI", "description", "name", "displayName", "version", "documentAlias", "ruleAlias"};
        elementIndexMap = new Hashtable<String, Integer>();
        int i = 0;
        while (i < KEYS.length) {
            elementIndexMap.put(KEYS[i], new Integer(i));
            ++i;
        }
    }

    public MetadataFileHandler() {
        this.aliasFileMap = new Hashtable<String, List<String>>();
        this.fileAliasMap = new Hashtable<String, List<String>>();
        this.buffer = new StringBuffer();
        this.currentRuleAliasBuffer = new StringBuffer();
        this.identity = new SMLIFIdentity();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String elementData = new String(ch, start, length);
        String trimmedElementData = elementData.trim();
        if (this.POSITION_INDICATOR[0] || this.POSITION_INDICATOR[1] || this.POSITION_INDICATOR[3] || this.POSITION_INDICATOR[4] || this.POSITION_INDICATOR[5] || this.POSITION_INDICATOR[6]) {
            this.buffer.append(trimmedElementData);
        } else if (this.POSITION_INDICATOR[2]) {
            this.buffer.append(elementData);
        } else if (this.POSITION_INDICATOR[7]) {
            this.currentRuleAliasBuffer.append(trimmedElementData);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("alias".equals(qName)) {
            String alias = this.buffer.toString().trim();
            this.addToList(this.aliasFileMap, alias, this.lastFile);
            this.addToList(this.fileAliasMap, this.lastFile, alias);
        } else if ("baseURI".equals(qName)) {
            this.identity.setBaseURI(this.buffer.toString().trim());
        } else if ("name".equals(qName)) {
            this.identity.setName(this.buffer.toString().trim());
        } else if ("version".equals(qName)) {
            this.identity.setVersion(this.buffer.toString().trim());
        } else if ("displayName".equals(qName)) {
            this.identity.setDisplayName(this.buffer.toString().trim());
        } else if ("description".equals(qName)) {
            this.identity.setDescription(SMLValidatorUtil.removeLineBreaks((String)this.buffer.toString()));
        } else if ("ruleBinding".equals(qName)) {
            if (this.currentRuleAliasBuffer.length() > 0) {
                String docAlias = null;
                if (this.buffer.length() > 0) {
                    docAlias = this.buffer.toString().trim();
                }
                String ruleAlias = this.currentRuleAliasBuffer.toString().trim();
                this.addToList(this.aliasRuleBinding, docAlias, ruleAlias);
                this.addToList(this.ruleAliasBinding, ruleAlias, docAlias);
            }
            this.buffer = new StringBuffer();
            this.currentRuleAliasBuffer = new StringBuffer();
        }
        int inx = this.getIndex(qName);
        if (inx >= 0) {
            this.POSITION_INDICATOR[inx] = false;
            if (inx <= 5) {
                this.buffer = new StringBuffer();
            }
        }
        super.endElement(uri, localName, qName);
    }

    private void addToList(Map<String, List<String>> storage, String key, String value) {
        List<String> list = storage.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            storage.put(key, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int inx = this.getIndex(qName);
        if (inx >= 0) {
            this.POSITION_INDICATOR[inx] = true;
        } else if (ELEMENT_FILE.equals(qName)) {
            this.lastFile = attributes.getValue(ATTRIBUTE_PATH);
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private int getIndex(String key) {
        Integer inx = elementIndexMap.get(key);
        if (inx != null) {
            return inx;
        }
        return -1;
    }

    public Map<String, List<String>> getAliasFileMap() {
        return this.aliasFileMap;
    }

    public Map<String, List<String>> getFileAliasMap() {
        return this.fileAliasMap;
    }

    public Map<String, List<String>> getRuleAliasBinding() {
        return this.ruleAliasBinding;
    }

    public Map<String, List<String>> getAliasRuleBinding() {
        return this.aliasRuleBinding;
    }

    public SMLIFIdentity getIdentity() {
        return this.identity;
    }

    public void addAlias(String id, String[] aliases) {
        this.dirty = true;
        int i = 0;
        while (i < aliases.length) {
            this.addToList(this.fileAliasMap, id, aliases[i]);
            this.addToList(this.aliasFileMap, aliases[i], id);
            ++i;
        }
    }

    public void addRuleBinding(String alias, String[] rules) {
        this.dirty = true;
        int i = 0;
        while (i < rules.length) {
            this.addToList(this.ruleAliasBinding, rules[i], alias);
            this.addToList(this.aliasRuleBinding, alias, rules[i]);
            ++i;
        }
    }

    public void write(PrintStream printStream) {
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println(SMLValidatorUtil.beginTagFor((String)ELEMENT_METADATA));
        this.writeFields(printStream, new String[][]{{"name", this.identity.getName()}, {"displayName", this.identity.getDisplayName()}, {"version", this.identity.getVersion()}, {"baseURI", this.identity.getBaseURI()}});
        if (this.identity.getDescription() != null) {
            printStream.println("\t" + SMLValidatorUtil.beginTagFor((String)"description") + this.identity.getDescription() + "\n" + "\t" + SMLValidatorUtil.endTagFor((String)"description"));
        }
        for (String currentRule : this.ruleAliasBinding.keySet()) {
            List<String> aliases = this.ruleAliasBinding.get(currentRule);
            int i = 0;
            int aliasCount = aliases.size();
            while (i < aliasCount) {
                printStream.println("\t" + SMLValidatorUtil.beginTagFor((String)"ruleBinding"));
                String docAlias = aliases.get(i);
                if (docAlias != null) {
                    printStream.println("\t\t" + SMLValidatorUtil.createElementTag((String)"documentAlias", (String)docAlias));
                }
                printStream.println("\t\t" + SMLValidatorUtil.createElementTag((String)"ruleAlias", (String)currentRule));
                printStream.println("\t" + SMLValidatorUtil.endTagFor((String)"ruleBinding"));
                ++i;
            }
        }
        for (String currentFile : this.fileAliasMap.keySet()) {
            StringBuffer aliasesBuffer = new StringBuffer();
            CMDBfInternalUtility.addElement((StringBuffer)aliasesBuffer, (int)1, (String)ELEMENT_FILE, (boolean)false, (boolean)false);
            aliasesBuffer.append(" path=\"" + currentFile + "\"" + ">");
            printStream.println(aliasesBuffer.toString());
            List<String> aliases = this.fileAliasMap.get(currentFile);
            int i = 0;
            int aliasCount = aliases.size();
            while (i < aliasCount) {
                printStream.println("\t\t" + SMLValidatorUtil.createElementTag((String)"alias", (String)aliases.get(i)));
                ++i;
            }
            printStream.println("\t" + SMLValidatorUtil.endTagFor((String)ELEMENT_FILE));
        }
        printStream.println(SMLValidatorUtil.endTagFor((String)ELEMENT_METADATA));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void writeFields(PrintStream printStream, String[][] fields) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i][1] != null) {
                printStream.println("\t" + SMLValidatorUtil.createElementTag((String)fields[i][0], (String)fields[i][1]));
            }
            ++i;
        }
    }

    public void setField(byte field, String value) {
        boolean originalDirtyState = this.dirty;
        this.dirty = true;
        switch (field) {
            case 0: {
                this.identity.setName(value);
                break;
            }
            case 2: {
                this.identity.setVersion(value);
                break;
            }
            case 4: {
                this.identity.setBaseURI(value);
                break;
            }
            case 3: {
                this.identity.setDescription(value);
                break;
            }
            case 1: {
                this.identity.setDisplayName(value);
                break;
            }
            default: {
                this.dirty = originalDirtyState;
            }
        }
    }
}

