/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.internal.repository.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceFacet;
import org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceInstance;
import org.eclipse.cosmos.rm.internal.repository.application.ISMLResourceProperty;
import org.eclipse.cosmos.rm.internal.repository.application.impl.SMLFileResourceFacet;
import org.eclipse.cosmos.rm.internal.repository.application.impl.SMLFileResourceInstance;
import org.eclipse.cosmos.rm.internal.repository.application.impl.SMLResourceProperty;
import org.eclipse.cosmos.rm.internal.repository.application.impl.TypeInfoHandler;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLIFIdentity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLRepositoryUtil {
    public static ISMLResourceInstance[] retrieveResources(ISMLRepository repository, ISMLResourceInstance document, Node root) {
        if (document == null || root == null) {
            return new ISMLResourceInstance[0];
        }
        SMLRepositoryUtil.parseDocument((SMLFileInstanceDocument)((Object)document), repository);
        ArrayList<ISMLResourceInstance> resourceList = new ArrayList<ISMLResourceInstance>();
        SMLRepositoryUtil.loadResources(repository, document, resourceList, root, 0, 1);
        return resourceList.toArray(new ISMLResourceInstance[resourceList.size()]);
    }

    public static ISMLResourceFacet[] retrieveFacets(ISMLResourceInstance document, Node root, ISMLRepository repository) {
        if (document == null || root == null) {
            return new ISMLResourceFacet[0];
        }
        SMLRepositoryUtil.parseDocument((SMLFileInstanceDocument)((Object)document), repository);
        ArrayList<ISMLResourceFacet> facetList = new ArrayList<ISMLResourceFacet>();
        SMLRepositoryUtil.loadFacets(repository, document, facetList, root, 0, 1);
        return facetList.toArray(new ISMLResourceFacet[facetList.size()]);
    }

    private static void loadResources(ISMLRepository repository, ISMLResourceInstance document, List<ISMLResourceInstance> resourceList, Node root, int currentDepth, int maximumDepth) {
        SMLRepositoryUtil.loadChildren(repository, resourceList, document, root, currentDepth, maximumDepth, null, "itemType", "itemRef", SMLFileResourceInstance.class);
    }

    private static void loadFacets(ISMLRepository repository, ISMLResourceInstance document, List<ISMLResourceFacet> facetList, Node root, int currentDepth, int maximumDepth) {
        SMLRepositoryUtil.loadChildren(repository, facetList, document, root, currentDepth, maximumDepth, "facetsType", "facetBaseType", "facetRef", SMLFileResourceFacet.class);
    }

    public static boolean isDerivedType(ISMLRepository repository, Node child, String uri, String localTypeName) {
        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
        Map hierarchyInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", (Object)null);
        if (hierarchyInfo == null || typeInfo == null) {
            return false;
        }
        String expectedType = String.valueOf(uri) + ":" + localTypeName;
        String currentType = SMLRepositoryUtil.retrieveType(typeInfo, child.getNamespaceURI(), child.getLocalName());
        do {
            if (currentType == null || !currentType.equals(expectedType)) continue;
            return true;
        } while ((currentType = SMLRepositoryUtil.getParent(hierarchyInfo, currentType)) != null);
        return false;
    }

    public static String retrieveType(Map<String, Map<String, String>> typeInfo, String namespaceURI, String localTypeName) {
        if (typeInfo == null || namespaceURI == null || localTypeName == null) {
            return null;
        }
        Map types = SMLValidatorUtil.retrieveNestedMap(typeInfo, (String)namespaceURI, (boolean)false);
        return types == null ? null : (String)types.get(localTypeName);
    }

    private static String getParent(Map<String, Map<String, String>> hierarchyInfo, String type) {
        String[] typeTokens = SMLRepositoryUtil.tokenizeQualifiedName(type);
        if (typeTokens[0] == null || typeTokens[1] == null) {
            return null;
        }
        Map hierarchy = SMLValidatorUtil.retrieveNestedMap(hierarchyInfo, (String)typeTokens[0], (boolean)false);
        if (hierarchy == null) {
            return null;
        }
        return (String)hierarchy.get(typeTokens[1]);
    }

    public static void parseDocument(SMLFileInstanceDocument document, ISMLRepository repository) {
        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
        Map hierarchyInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", (Object)null);
        typeInfo = typeInfo == null ? new Hashtable() : typeInfo;
        hierarchyInfo = hierarchyInfo == null ? new Hashtable() : hierarchyInfo;
        try {
            Node schemaLocation;
            Node root = document.getDOMDocument().getFirstChild();
            NamedNodeMap attributes = root.getAttributes();
            Node node = schemaLocation = attributes == null ? null : attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (schemaLocation == null) {
                return;
            }
            StringTokenizer schemaFiles = new StringTokenizer(schemaLocation.getNodeValue());
            while (schemaFiles.hasMoreTokens()) {
                String uri = schemaFiles.nextToken();
                String location = schemaFiles.nextToken();
                SMLRepositoryUtil.processSchemaFile(SMLRepositoryUtil.getDocumentPath(document), typeInfo, hierarchyInfo, uri, location);
            }
        }
        catch (RepositoryOperationException e) {
            e.printStackTrace();
            return;
        }
        repository.setProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", typeInfo);
        repository.setProperty("org.eclipse.cosmos.rm.repository.HIERARCHY_INFORMATION", hierarchyInfo);
    }

    private static void processSchemaFile(String parentLocation, Map<String, Map<String, String>> typeInfo, Map<String, Map<String, String>> hierarchyInfo, String uri, String location) {
        if (typeInfo.get(uri) != null) {
            return;
        }
        try {
            parentLocation = parentLocation.replace('\\', '/');
            if (!location.startsWith(parentLocation)) {
                int lastSegment = parentLocation.lastIndexOf(47);
                String parentFolder = lastSegment < 0 ? parentLocation : parentLocation.substring(0, lastSegment);
                location = String.valueOf(parentFolder) + "/" + location;
            }
            FileInputStream fis = new FileInputStream(location);
            TypeInfoHandler typeInfoHandler = new TypeInfoHandler(typeInfo, hierarchyInfo);
            SMLValidatorUtil.saxParseDocument((InputStream)fis, (DefaultHandler)typeInfoHandler);
            Map<String, String> importedStatement = typeInfoHandler.getImportStatements();
            for (String importedURI : importedStatement.keySet()) {
                SMLRepositoryUtil.processSchemaFile(location, typeInfo, hierarchyInfo, importedURI, importedStatement.get(importedURI));
            }
        }
        catch (Exception exception) {}
    }

    public static ISMLResourceProperty[] retrieveProperties(ISMLRepository repository, ISMLResourceInstance document, Node root) {
        if (document == null || root == null) {
            return new ISMLResourceProperty[0];
        }
        SMLRepositoryUtil.parseDocument((SMLFileInstanceDocument)((Object)document), repository);
        ArrayList<ISMLResourceProperty> propertiesList = new ArrayList<ISMLResourceProperty>();
        SMLRepositoryUtil.loadProperties(repository, document, propertiesList, root, 0, 1);
        return propertiesList.toArray(new ISMLResourceProperty[propertiesList.size()]);
    }

    private static void loadProperties(ISMLRepository repository, ISMLResourceInstance document, List<ISMLResourceProperty> propertiesList, Node root, int currentDepth, int maxDepth) {
        SMLRepositoryUtil.loadChildren(repository, propertiesList, document, root, currentDepth, maxDepth, "propertiesType", "propertyBaseType", "propertyRef", SMLResourceProperty.class);
    }

    private static void loadChildren(ISMLRepository repository, List list, ISMLResourceInstance document, Node root, int currentDepth, int maxDepth, String groupElementType, String elementType, String referenceType, Class entity) {
        NodeList children = root.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (groupElementType != null && currentDepth < maxDepth && SMLRepositoryUtil.isDerivedType(repository, child, "http://www.cosmos.rm/dataCenter/core", groupElementType)) {
                    SMLRepositoryUtil.loadChildren(repository, list, document, child, currentDepth + 1, maxDepth, groupElementType, elementType, referenceType, entity);
                } else if (SMLRepositoryUtil.isDerivedType(repository, child, "http://www.cosmos.rm/dataCenter/core", elementType) || "http://www.cosmos.rm/dataCenter/core".equals(child.getNamespaceURI()) && referenceType.equals(child.getLocalName())) {
                    try {
                        Object item = entity.getMethod("load", ISMLRepository.class, Node.class).invoke(null, repository, children.item(i));
                        if (item != null) {
                            entity.getMethod("setParentDocument", ISMLDocument.class).invoke(item, document);
                            list.add(item);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public static String retrieveRootAttribute(Node node, String uri, String localName) {
        Node attribute;
        NamedNodeMap attributes = node == null ? null : node.getAttributes();
        Node node2 = attribute = attributes == null ? null : attributes.getNamedItemNS(uri, localName);
        if (attribute == null && attributes != null) {
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                Node currentAttribute = attributes.item(i);
                if (localName.equals(currentAttribute.getLocalName())) {
                    attribute = currentAttribute;
                    break;
                }
                ++i;
            }
        }
        return attribute == null ? null : attribute.getNodeValue();
    }

    public static String firstSegment(String path, int index) {
        StringTokenizer segments = new StringTokenizer(path, "\\/");
        if (index > segments.countTokens()) {
            return null;
        }
        String desiredSegment = null;
        int i = 0;
        while (i < index) {
            desiredSegment = segments.nextToken();
            ++i;
        }
        return desiredSegment;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() <= 0;
    }

    public static void appendSMLIFIdentityInformation(StringBuffer buffer, ISMLIFIdentity identity) {
        buffer.append(ISMLRepositoryConstants.smlifStart).append("\t").append("<").append(SMLValidatorUtil.tagNameFor((String)"smlif", (String)"identity"));
        buffer.append(">").append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"name")).append(identity.getName()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"name"));
        if (!SMLRepositoryUtil.isNullOrEmpty(identity.getVersion())) {
            buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"version")).append(identity.getVersion()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"version"));
        }
        if (!SMLRepositoryUtil.isNullOrEmpty(identity.getDisplayName())) {
            buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"displayName")).append(identity.getDisplayName()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"displayName"));
        }
        if (!SMLRepositoryUtil.isNullOrEmpty(identity.getBaseURI())) {
            buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"baseURI")).append(identity.getBaseURI()).append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"baseURI"));
        }
        buffer.append("\n").append("\t").append("\t").append(SMLValidatorUtil.beginTagFor((String)"smlif", (String)"description")).append("\n").append("\t").append("\t").append("\t").append(identity.getDescription()).append("\n").append("\t").append("\t").append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"description")).append("\n").append("\t").append(SMLValidatorUtil.endTagFor((String)"smlif", (String)"identity")).append("\n");
    }

    public static String getAlternativeId(ISMLRepository repository, String id) {
        String contextDirectory = repository.getProperty("root.directory", "");
        if (id.startsWith(contextDirectory)) {
            return id.substring(contextDirectory.length() + 1);
        }
        return String.valueOf(contextDirectory) + (contextDirectory.endsWith("/") || contextDirectory.endsWith("\\") ? "" : "/") + id;
    }

    public static String getDocumentName(ISMLDocument document) {
        return SMLRepositoryUtil.findDocumentLocation(document, false);
    }

    public static String getDocumentPath(ISMLDocument document) {
        return SMLRepositoryUtil.findDocumentLocation(document, true);
    }

    private static String findDocumentLocation(ISMLDocument document, boolean absolute) {
        ISMLRepository repository = ((SMLFileDocument)document).getRepository();
        String contextDirectory = repository.getProperty("root.directory", "");
        String id = document.getMetadata().getId();
        boolean startsWithContext = id.startsWith(contextDirectory);
        return absolute ? (startsWithContext ? id : SMLRepositoryUtil.getAlternativeId(repository, id)) : (startsWithContext ? SMLRepositoryUtil.getAlternativeId(repository, id) : id);
    }

    public static String[] tokenizeQualifiedName(String name) {
        if (name == null) {
            return new String[2];
        }
        int colonInx = -1;
        colonInx = name.lastIndexOf(58);
        String prefix = colonInx < 0 ? null : name.substring(0, colonInx);
        name = colonInx < 0 ? name : name.substring(colonInx + 1);
        return new String[]{prefix, name};
    }

    public static String retrieveAlias(ISMLDocument document, Map<String, String[]> aliases) {
        String id = document.getMetadata().getId();
        String[] documentAliases = aliases.get(id);
        return documentAliases == null || documentAliases.length < 0 ? SMLRepositoryUtil.getDocumentName(document) : documentAliases[0];
    }

    public static String[] toStringArray(Collection<List<String>> collection) {
        if (collection == null || collection.size() <= 0) {
            return new String[0];
        }
        ArrayList<String> finalList = new ArrayList<String>();
        for (List<String> ruleList : collection) {
            int i = 0;
            int ruleListCount = ruleList.size();
            while (i < ruleListCount) {
                String rule = ruleList.get(i);
                if (!finalList.contains(rule)) {
                    finalList.add(rule);
                }
                ++i;
            }
        }
        return finalList.toArray(new String[finalList.size()]);
    }
}

