/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.application;

import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocumentFragment;

/**
 * A convenience API for a more strongly typed SML document
 * fragment.  Facets can contain other facets, properties, and
 * resources.
 * 
 * @author Ali Mehregani
 */
public interface ISMLResourceFacet extends ISMLDocumentFragment, ISMLResourceBase
{ 
	/**
	 * If this object happens to represent a reference to a facet
	 * (i.e. isReference() returns true), then this method will have it
	 * resolved to the actual facet.  If isReference() happens to
	 * return false, then the return value of this method is this
	 * object.
	 * 
	 * @return An object representing the resolved resource that 
	 * this reference points to 
	 */
    public ISMLResourceFacet resolveReference();
    
    
    /**
     * Retrieves and returns the resources that are directly referenced 
     * by this facet.
     * 
     * @return The direct resources referenced by this facet
     */
    public ISMLResourceInstance[] retrieveResources();
    
    
    /**
     * Retrieves and returns the facets that are directly referenced
     * by this facet.
     * 
     * @return The direct facets referenced by this facet
     */
    public ISMLResourceFacet[] retrieveFacets();
    
    
    /**
     * Retrieves and returns the properties that are directly referenced
     * by this facet.
     * 
     * @return The direct properties referenced by this facet
     */
    public ISMLResourceProperty[] retrieveProperties();
}
