/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * This interface allows adopters to provide an alternate implementation
 * of the artifact factory in order to instantiate different implementations
 * of the artifact (POJO) interfaces.  A default implementation of this interface
 * can be obtained by calling <code>QueryInputArtifactFactory.getInstance()</code>.
 * 
 * 
 * @author David Whiteman
 */
public interface IQueryInputArtifactFactory {

	/**
	 * Answer a new instance of {@link IInstanceIdConstraint}
	 * 
	 * @return
	 */
	public abstract IInstanceIdConstraint createInstanceIdConstraint();

	/**
	 * Answer a new instance of {@link IInstanceId}
	 * 
	 * @return
	 */
	public abstract IInstanceId createInstanceId();

	/**
	 * Answer a new instance of {@link IRelationshipEndpoint} of the indicated
	 * type.  An item reference represents an endpoint in a relationship.
	 * The type can either be SOURCE or TARGET, indicating the role in
	 * the relationship.
	 * 
	 * @param type {@link IRelationshipEndpoint#SOURCE} or 
	 * {@link IRelationshipEndpoint#TARGET}
	 * @return
	 */
	public abstract IRelationshipEndpoint createRelationshipEndpoint(int type);

	/**
	 * Answer a new instance of {@link IItemReference}
	 * @return
	 */
	public abstract IItemReference createItemReference();

	/**
	 * Answer a new instance of {@link IItemTemplate} with the given
	 * id.
	 * 
	 * @param id
	 * @return
	 */
	public abstract IItemTemplate createItemTemplate(String id);

	/**
	 * Answer a new instance of IOperator of the given type.
	 * These types map to the subelements of a property value constraint.
	 * See the {@link IOperator} class for a complete list.
	 * 
	 * @param type
	 * @return
	 */
	public abstract IOperator createOperator(int type);

	/**
	 * Answer a new instance of IPrefixMapping
	 * 
	 * @return
	 */
	public abstract IPrefixMapping createPrefixMapping();

	/**
	 * Answer a new instance of IProperty
	 * 
	 * @return
	 */
	public abstract IProperty createProperty();

	/**
	 * Answer a new instance of IPropertyId
	 * 
	 * @return
	 */
	public abstract IPropertyId createPropertyId();

	/**
	 * Answer a new instance of {@link IContentSelector}
	 * 
	 * @return
	 */
	public abstract IContentSelector createContentSelector();

	/**
	 * Answer a new instance of {@link IPropertyValue}
	 * 
	 * @return
	 */
	public abstract IPropertyValue createPropertyValue();

	/**
	 * Answer a new instance of IQuery representing a <query> element
	 * 
	 * @return
	 */
	public abstract IQuery createQuery();

	/**
	 * Answer a new instance of IRecordType
	 * 
	 * @return
	 */
	public abstract IRecordType createRecordType();

	/**
	 * Answer a new instance of {@link IRelationshipTemplate}, setting the id field of the template
	 * 
	 * @param id
	 * @return
	 */
	public abstract IRelationshipTemplate createRelationshipTemplate(String id);

	/**
	 * Answer a new instance of {@link IXPathExpression}
	 * 
	 * @return
	 */
	public abstract IXPathExpression createXPathExpression(URI dialectURI);

	/**
	 * Answer a new instance of {@link IDepthLimit}
	 * 
	 * @return
	 */
	public abstract IDepthLimit createDepthLimit();

	/**
	 * Answer a new instance of {@link ISelectedRecordType}
	 * 
	 * @return
	 */
	public abstract ISelectedRecordType createSelectedRecordType();

	/**
	 * Answer a new instance of {@link IRecordConstraint}
	 * 
	 * @return
	 */
	public abstract IRecordConstraint createRecordConstraint();

}