/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents an endpoint in a relationship being queried, with role and
 * cardinality information.
 * 
 * 
 * @author David Whiteman
 */
public interface IRelationshipEndpoint extends IItemReference, IXMLWritable
{
	/**
	 * Source item role of relationship endpoint
	 */
	public static final int SOURCE = 0;

	/**
	 * Target item role of relationship endpoint
	 */
	public static final int TARGET = 1;
	
	/**
	 * Indicates no cardinality for this end of the relationship.
	 * Used in minimum and maximum properties of this instance.
	 */
	public static final int NO_CARDINALITY = -1;


	/**
	 * Answer the minimum cardinality for this end of the
	 * relationship.  NO_CARDINALITY indicates there is no minimum.
	 * 
	 * @return
	 */
	public int getMinimum();

	/**
	 * Set the minimum cardinality for this end of the
	 * relationship.  NO_CARDINALITY indicates there is no minimum.
	 * 
	 * @param minimum
	 */
	public void setMinimum(int minimum);

	/**
	 * Answer the maximum cardinality for this end of the
	 * relationship.  NO_CARDINALITY indicates there is no maximum.
	 * 
	 * @return
	 */
	public int getMaximum();

	/**
	 * Set the maximum cardinality for this end of the
	 * relationship.  NO_CARDINALITY indicates there is no maximum.
	 * 
	 * @param maximum
	 */
	public void setMaximum(int maximum);

	/**
	 * Answer the type of this ItemReference.
	 * Possible values are SOURCE and TARGET.
	 * 
	 * @return int type
	 */
	public int getType();
}
