/**********************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.net.URI;

/**
 * TargetElementNode models an instance element constrained by one or more SML target* constraints, e.g. a targetElement attribute
 *
 * @author sleeloy
 * @author John Arwe
 */
public class TargetElementNode extends ElementNode {

	/**
	 * the uri is an element instance
	 */
	public static final byte INSTANCE_TYPE = 0x01;
	/**
	 * the uri is a type instance
	 */
	public static final byte TYPE_TYPE = 0x11;

	protected boolean required;			// value of sml:targetRequired constraint from governing element declaration
	/*
	protected String targetElement;		// value of sml:targetElement constraint from governing element declaration, or null
	protected String targetType;				// value of sml:targetType constraint from governing element declaration, or null
	// also need corresponding getters/setters - their types might better be QName vs String above too
	*/
	private boolean smlref;					// value of sml:ref attribute from SML reference PSVI (from instance or Schema default/fixed values)
	private boolean nilref;						// value of sml:nilref attribute from SML reference PSVI (from instance or Schema default/fixed values)
	private URI baseURIValue;					// current running value of base URI infoset property, may be relative or null
	protected String targetURI;
	protected byte targetURIType = INSTANCE_TYPE;

	private String[] aliases;
	private int documentPosition;

	public TargetElementNode() {
		super();
	}

	public TargetElementNode(String name, String filePath, int line, int column) {
		super(name, filePath, line, column);
	}

	public String getTargetURI() {
		return targetURI;
	}

	public void setTargetURI(String uri) {
		this.targetURI = uri;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public boolean isSMLref() {
		return smlref;
	}

	public void setSMLRef(boolean smlref) {
		this.smlref = smlref;
	}

	public boolean isNilref() {
		return nilref;
	}

	public void setNilref(boolean nilref) {
		this.nilref = nilref;
	}

	public byte getTargetURIType() {
		return targetURIType;
	}

	public void setTargetURIType(byte uriType) {
		this.targetURIType = uriType;
	}

	/**
	 * @return the aliases
	 */
	public String[] getAliases()
	{
		return aliases;
	}

	/**
	 * @param aliases the aliases to set
	 */
	public void setAliases(String[] aliases)
	{
		this.aliases = aliases;
	}

	/**
	 * @return the documentPosition
	 */
	public int getDocumentPosition()
	{
		return documentPosition;
	}

	/**
	 * @param documentPosition the documentPosition to set
	 */
	public void setDocumentPosition(int documentPosition)
	{
		this.documentPosition = documentPosition;
	}

	/**
	 * @return the base URI value current at the point in the target element node's position in its containing document
	 */
	public URI getBaseURIValue()
	{
		return baseURIValue;
	}

	/**
	 * @param baseURIValue the base URI value current at the point in the target element node's position in its containing document
	 */
	public void setBaseURIValue(URI baseURIValue)
	{
		this.baseURIValue = baseURIValue;
	}
}
