/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <recordConstraintSupport> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IRecordConstraintSupport extends IXMLWritable
{
	/**
	 * set the recordTypeConstraint 
	 * 
	 * @param recordTypeConstraint
	 */
	public void setRecordTypeConstraint(boolean recordTypeConstraint);
		
	/**
	 * Retrieve the recordTypeConstraint
	 * 
	 * @return recordTypeConstraint
	 */
	public boolean isRecordTypeConstraint();

	
	/**
	 * set the propertyValueConstraint
	 * 
	 * @param propertyValueConstraint
	 */
	public void setPropertyValueConstraint(boolean propertyValueConstraint);
		
	/**
	 * Retrieve the propertyValueConstraint
	 * 
	 * @return Boolean propertyValueConstraint
	 */
	public boolean isPropertyValueConstraint();

	
	/**
	 * set the propertyValueOperators
	 * 
	 * @param propertyValueOperators
	 */
	public void setPropertyValueOperators(IPropertyValueOperators propertyValueOperators);
		
	/**
	 * Retrieve the propertyValueOperators
	 * 
	 * @return IPropertyValueOperators propertyValueOperators
	 */
	public IPropertyValueOperators getPropertyValueOperators();

}
