/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.op.impl;

import java.text.MessageFormat;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class OperationHandlerImpl
implements OperationHandler {
    static final String QUERY = "(qname={0})";
    private BundleContext context;

    protected void activate(ComponentContext ctxt) {
        this.context = ctxt.getBundleContext();
    }

    protected void deactivate(ComponentContext ctxt) {
        this.context = null;
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
        QName qname = null;
        qname = artifact.getResourceRef() != null ? ((ResourceType)artifact.getResourceRef()).getType() : artifact.getType();
        ServiceReference ref = this.getService(qname);
        if (ref != null) {
            IOperationHandler op = (IOperationHandler)this.context.getService(ref);
            op.invokeAction(ctxt, artifact, operation);
            this.context.ungetService(ref);
        }
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation) {
        QName qname = null;
        qname = content.getType() != null ? content.getType() : new QName("AdditionalContent");
        ServiceReference ref = this.getService(qname);
        if (ref != null) {
            IOperationHandler op = (IOperationHandler)this.context.getService(ref);
            op.invokeAction(ctxt, artifact, content, operation);
            this.context.ungetService(ref);
        }
    }

    private ServiceReference getService(QName qname) {
        ServiceReference ref = null;
        String query = MessageFormat.format(QUERY, qname.toString());
        try {
            ServiceReference[] refs = this.context.getServiceReferences(IOperationHandler.class.getName(), query);
            if (refs != null && refs.length > 0) {
                ref = refs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        return ref;
    }
}

