/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class J2eeApplicationType
implements IResourceHandler {
    protected static final QName J2EE = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_J2eeApplication");
    protected static final QName J2EE_NAME = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_J2eeApplication.Name");
    protected static final QName J2EE_VERSION = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_J2eeApplication.Version");
    protected static final String CMD_DIR = "cmd.exe /c dir \"{0}\"";
    protected static final String CMD_LS = "ls -d {0}";
    protected static final String Windows = "Windows";
    protected static final Pattern PATTERN_DIR = Pattern.compile("([0-9,]+) bytes free");
    protected static final Pattern PATTERN_LS = Pattern.compile("/[\\w.*]+");
    protected static final String OS_NAME = "os.name";
    protected static final String WIN_1 = "{0}\\{1}\\{2}";
    protected static final String WIN_2 = "{1}\\{2}";
    protected static final String WIN_3 = "{1}-{2}";
    protected static final String WIN_4 = "{0}\\{1}{2}";
    protected static final String WIN_5 = "{0}\\{1}-{2}";
    protected static final String WIN_6 = "{1}{2}";
    protected static final String UNIX_1 = "{0}/{1}/{2}";
    protected static final String UNIX_2 = "{1}/{2}";
    protected static final String UNIX_3 = "{1}-{2}";
    protected static final String UNIX_4 = "{0}/{1}{2}";
    protected static final String UNIX_5 = "{0}/{1}-{2}";
    protected static final String UNIX_6 = "{1}{2}";
    protected String[] unixRoots = new String[]{"/opt/", "/usr/local/"};
    protected String[] unixPatterns = new String[]{"{0}/{1}/{2}", "{1}/{2}", "{1}-{2}", "{0}/{1}{2}", "{0}/{1}-{2}", "{1}{2}"};
    protected String[] winRoots = new String[]{"C:", "C:\\Program Files"};
    protected String[] winPatterns = new String[]{"{0}\\{1}\\{2}", "{1}\\{2}", "{1}-{2}", "{0}\\{1}{2}", "{0}\\{1}-{2}", "{1}{2}"};

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, RequirementResourceConstraintType constraint) {
        String s;
        String product = null;
        String version = null;
        Object vendor = null;
        for (Object o : constraint.getResourceConstraintGroup()) {
            if (!(o instanceof JAXBElement)) continue;
            Object value = ((JAXBElement)o).getValue();
            String constraintValue = null;
            QName name = null;
            if (value instanceof PropertyConstraintType) {
                ConditionalPropertyConstraintType cc;
                if (value instanceof ConditionalPropertyConstraintType) {
                    cc = (ConditionalPropertyConstraintType)value;
                    name = cc.getPropertyName();
                    constraintValue = cc.getValue();
                } else if (value instanceof PropertyConstraintType) {
                    cc = (PropertyConstraintType)value;
                    name = cc.getPropertyName();
                    constraintValue = cc.getValue();
                }
            } else {
                boolean cfr_ignored_0 = value instanceof VersionConstraintType;
            }
            if (J2EE_NAME.equals(name)) {
                product = constraintValue;
                continue;
            }
            if (!J2EE_VERSION.equals(name)) continue;
            version = constraintValue;
        }
        if (System.getProperty(OS_NAME).contains(Windows)) {
            int i = 0;
            while (i < this.winPatterns.length) {
                s = this.winFind(MessageFormat.format(this.winPatterns[i], vendor, product, version));
                if (s != null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.unixPatterns.length) {
                s = this.unixFind(MessageFormat.format(this.unixPatterns[i], product, version, vendor));
                if (s != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
        return null;
    }

    public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
        return null;
    }

    protected String unixFind(String path) {
        int i = 0;
        while (i < this.unixRoots.length) {
            Matcher m;
            String s = this.runCommand(MessageFormat.format(CMD_LS, String.valueOf(this.unixRoots[i]) + path));
            if (s != null && (m = PATTERN_LS.matcher(s)).find()) {
                return String.valueOf(this.unixRoots[i]) + path;
            }
            ++i;
        }
        return null;
    }

    protected String winFind(String path) {
        int i = 0;
        while (i < this.winRoots.length) {
            Matcher m;
            String s = this.runCommand(MessageFormat.format(CMD_DIR, String.valueOf(this.winRoots[i]) + "\\" + path));
            if (s != null && (m = PATTERN_DIR.matcher(s)).find()) {
                return String.valueOf(this.winRoots[i]) + "\\" + path;
            }
            ++i;
        }
        return null;
    }

    private String runCommand(String command) {
        Process process;
        StringBuffer output;
        block4: {
            output = new StringBuffer();
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(command);
            if (process != null) break block4;
            return null;
        }
        try {
            BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = inStream.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        catch (Exception exception) {
            return null;
        }
        return output.toString();
    }
}

