/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.profile.cim.DatabaseSystemType;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class PostgresHandler
extends DatabaseSystemType
implements IResourceHandler {
    static final String POSTGRES = "Postgres";
    static final String POSTGRESQL = "PostgreSQL";
    static final String POSTGRES_PRODUCT_HKEY = "SOFTWARE\\PostgreSQL";
    static final String POSTGRES_VERSION_HKEY = "SOFTWARE\\PostgreSQL\\Installations\\postgresql-";
    static final String POSTGRES_WIN_LOCATION = "C:\\Program Files\\PostgreSQL";
    static final String POSTGRES_UNIX_FIND = "pgrep postgres";
    static final String POSTGRES_WIN_FIND = "pgsql-";
    static final String[] POSTGRES_PORT_CMD = new String[]{"/bin/sh", "-c", "netstat -an | grep PGSQL | grep "};
    static final String POSTGRES_VBS_SERVICE_CMD = "Set sh = CreateObject(\"Shell.Application\") \nIf sh.IsServiceRunning(\"SERVICE_NAME\") Then \n   wscript.Quit(1) \nEnd If \nwscript.Quit(0) \n";
    static final String POSTGRES_VBS_WORD_CMD = "Set sh = CreateObject(\"WScript.Shell\") \nwscript.Quit(sh.RegRead(\"HKLM\\SOFTWARE\\PostgreSQL\\Services\\pgsql-SERVICE_VERSION\\Port\")) \n";
    static final String SERVICE_NAME = "SERVICE_NAME";
    static final String SERVICE_VERSION = "SERVICE_VERSION";
    static final String STOPPING = "stopping";
    static final String REALHOWTO = "realhowto";
    static final String VBS = ".vbs";
    static final String WSCRIPT = "wscript ";

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint) {
        return false;
    }

    public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
        return null;
    }

    public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, RequirementResourceConstraintType constraint) {
        PropertyConstraintType prop;
        Object value;
        List ConstraintGroup = constraint.getResourceConstraintGroup();
        for (Object o : ConstraintGroup) {
            if (!(o instanceof JAXBElement) || !((value = ((JAXBElement)o).getValue()) instanceof PropertyConstraintType)) continue;
            prop = (PropertyConstraintType)value;
            if (prop.getPropertyName().equals(NAME)) {
                if (!prop.getValue().equalsIgnoreCase(POSTGRES)) {
                    return false;
                }
                NAME_VALUE = prop.getValue();
            }
            if (prop.getPropertyName().equals(VERSION)) {
                VERSION_VALUE = prop.getValue();
            }
            if (prop.getPropertyName().equals(PORT)) {
                PORT_VALUE = prop.getValue();
            }
            if (!prop.getPropertyName().equals(STATUS)) continue;
            STATUS_VALUE = prop.getValue();
        }
        for (Object o : ConstraintGroup) {
            if (!(o instanceof JAXBElement) || !((value = ((JAXBElement)o).getValue()) instanceof PropertyConstraintType)) continue;
            prop = (PropertyConstraintType)value;
            if (prop.getPropertyName().equals(NAME) && !this.resolveName()) {
                return false;
            }
            if (prop.getPropertyName().equals(VERSION) && !this.resolveVersion(VERSION_VALUE)) {
                return false;
            }
            if (prop.getPropertyName().equals(PORT)) {
                if (Utilities.getOS() == 1) {
                    if (VERSION_VALUE == null) return false;
                    if (!this.resolvePort(VERSION_VALUE, PORT_VALUE)) {
                        return false;
                    }
                } else {
                    if (Utilities.getOS() != 2) return false;
                    if (!this.resolvePort(null, PORT_VALUE)) {
                        return false;
                    }
                }
            }
            if (!prop.getPropertyName().equals(STATUS)) continue;
            boolean expected_status = true;
            if (STATUS_VALUE.equalsIgnoreCase(STOPPING)) {
                expected_status = false;
            }
            if (Utilities.getOS() == 1) {
                if (VERSION_VALUE == null) return false;
                if (this.resolveStatus(VERSION_VALUE) == expected_status) continue;
                return false;
            }
            if (Utilities.getOS() != 2) return false;
            if (this.resolveStatus(null) == expected_status) continue;
            return false;
        }
        return true;
    }

    private boolean resolveName() {
        if (Utilities.getOS() == 1) {
            if (JNIUtils.libraryLoaded((String)PostgresHandler.getCurrentPath(), (HashMap)WinRegAPI.libNames)) {
                if (WinRegAPI.isWindowsRegistryKey32((int)8, (String)POSTGRES_PRODUCT_HKEY)) {
                    return true;
                }
                File testDir = new File(POSTGRES_WIN_LOCATION);
                if (testDir.exists()) {
                    return true;
                }
            }
        } else if (Utilities.getOS() == 2) {
            int i = 0;
            while (i < unixPatterns.length) {
                String s = PostgresHandler.unixFind(MessageFormat.format(unixPatterns[i], POSTGRESQL, "", ""));
                if (s != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean resolveVersion(String version) {
        if (Utilities.getOS() == 1) {
            if (JNIUtils.libraryLoaded((String)PostgresHandler.getCurrentPath(), (HashMap)WinRegAPI.libNames)) {
                if (WinRegAPI.isWindowsRegistryKey32((int)8, (String)(POSTGRES_VERSION_HKEY + version))) {
                    return true;
                }
                File testDir = new File("C:\\Program Files\\PostgreSQL\\" + version);
                if (testDir.exists()) {
                    return true;
                }
            }
        } else if (Utilities.getOS() == 2) {
            int i = 0;
            while (i < unixPatterns.length) {
                String s = PostgresHandler.unixFind(MessageFormat.format(unixPatterns[i], POSTGRESQL, version, ""));
                if (s != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isServiceRunning(String serviceName) {
        try {
            File file = File.createTempFile(REALHOWTO, VBS);
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            fw.write(this.getVBSServiceCmd(serviceName));
            fw.close();
            Process p = Runtime.getRuntime().exec(WSCRIPT + file.getPath());
            p.waitFor();
            return p.exitValue() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private int getRegDword(String version) {
        try {
            File file = File.createTempFile(REALHOWTO, VBS);
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            fw.write(this.getVBSRegWordCmd(version));
            fw.close();
            Process p = Runtime.getRuntime().exec(WSCRIPT + file.getPath());
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private boolean resolveStatus(String version) {
        if (Utilities.getOS() == 1) {
            return this.isServiceRunning(POSTGRES_WIN_FIND + version);
        }
        if (Utilities.getOS() == 2) {
            return PostgresHandler.runCommand(POSTGRES_UNIX_FIND).length() > 0;
        }
        return false;
    }

    private boolean resolvePort(String version, String port) {
        if (Utilities.getOS() == 1) {
            return Integer.toString(this.getRegDword(version)).equalsIgnoreCase(port);
        }
        if (Utilities.getOS() == 2) {
            return PostgresHandler.runCommand(POSTGRES_PORT_CMD + port).length() > 0;
        }
        return false;
    }

    private String getVBSServiceCmd(String serviceName) {
        return POSTGRES_VBS_SERVICE_CMD.replace(SERVICE_NAME, serviceName);
    }

    private String getVBSRegWordCmd(String version) {
        return POSTGRES_VBS_WORD_CMD.replace(SERVICE_VERSION, version);
    }
}

