/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.op;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.SubstitutionType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class AdditionalContentOperation
implements IOperationHandler {
    static final QName ADD = new QName("AdditionalContent");

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation) {
        switch (operation) {
            case INSTALL: {
                this.copyContent(ctxt, artifact, content);
            }
        }
    }

    private void copyContent(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content) {
        String arg = ((ArgumentType)artifact.getArguments().getArgument().get(0)).getValue();
        arg = ctxt.substituteVariables(arg);
        try {
            String line;
            LinkedHashMap<String, String> sub = new LinkedHashMap<String, String>();
            for (SubstitutionType s : content.getSubstitution()) {
                sub.put(s.getPattern(), ctxt.substituteVariables(s.getValue()));
            }
            ContentType c = ctxt.getContentById(content.getContentRef());
            String filename = this.filePart(URI.create(c.getPathname()));
            if (filename == null) {
                return;
            }
            InputStream src = ctxt.getInputStreamForPath(c.getPathname());
            String dest = String.valueOf(arg) + File.separator + filename;
            BufferedReader r = new BufferedReader(new InputStreamReader(src));
            if (!new File(arg).exists()) {
                new File(arg).mkdirs();
            }
            BufferedWriter w = new BufferedWriter(new FileWriter(new File(dest)));
            while ((line = r.readLine()) != null) {
                for (Map.Entry e : sub.entrySet()) {
                    line = line.replaceAll((String)e.getKey(), (String)e.getValue());
                }
                w.write(line);
                w.newLine();
                w.flush();
            }
            r.close();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String filePart(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.getPath() == null) {
            return null;
        }
        String[] parts = uri.getPath().split("/");
        if (parts.length == 0) {
            return null;
        }
        return parts[parts.length - 1];
    }
}

