/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.op;

import java.io.File;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class DirectoryOperation
implements IOperationHandler {
    static final QName DIR = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_Directory");

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
        switch (operation) {
            case UNINSTALL: {
                this.uninstall(ctxt, artifact);
            }
        }
    }

    public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation) {
    }

    private void uninstall(SDDContext ctxt, ArtifactType artifact) {
        ResourceType r;
        if (artifact.getResourceRef() != null && DIR.equals((r = (ResourceType)artifact.getResourceRef()).getType())) {
            this.deleteDirectory(ctxt.substituteVariables(r.getName()));
        }
    }

    private void deleteDirectory(String path) {
        File installDir = new File(path);
        if (installDir.exists() && installDir.isDirectory()) {
            this.delete(installDir);
        }
    }

    private void delete(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.delete(f);
                } else {
                    f.delete();
                }
                ++n2;
            }
            file.delete();
        }
    }
}

