/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.ConditionType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalDerivedVariableExpressionType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.DerivedVariableType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.ParametersType;
import org.eclipse.cosmos.me.sdd.schema.PropertyType;
import org.eclipse.cosmos.me.sdd.schema.ResourcePropertyType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.schema.VariablesType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableResolver {
    private SDDContext ctxt;
    private ResourceHandler handler;
    private LogService log;

    public VariableResolver(SDDContext ctxt, ResourceHandler handler, LogService log) {
        this.ctxt = ctxt;
        this.handler = handler;
        this.log = log;
    }

    public void installableUnitResolver() {
        InstallableUnitType iu = this.ctxt.getDeploymentDescriptor().getInstallableUnit();
        this.resolve(iu.getVariables());
    }

    private void resolve(VariablesType vt) {
        if (vt != null) {
            List variables = vt.getParametersOrResourcePropertyOrDerivedVariable();
            for (Object o : variables) {
                Object obj = ((JAXBElement)o).getValue();
                if (obj instanceof DerivedVariableType) {
                    this.resolve((DerivedVariableType)obj);
                }
                if (obj instanceof ParametersType) {
                    this.resolve((ParametersType)obj);
                }
                if (!(obj instanceof ResourcePropertyType)) continue;
                this.resolve((ResourcePropertyType)obj);
            }
            vt.getParametersOrResourcePropertyOrDerivedVariable().add(this.ctxt.getVariables());
        }
    }

    private void resolve(ResourcePropertyType var) {
        this.log.log(3, "ResourcePropertyType: name=" + var.getPropertyName() + "   ref=" + ((ResourceType)var.getResourceRef()).getType() + "   id=" + var.getId());
        if (this.ctxt.containsVariable(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(ResourcePropertyType var):" + var.getId() + " - (" + this.ctxt.getVariable(String.valueOf(var.getId()) + ") already assigned\n"));
            ResourceType rsrc = (ResourceType)var.getResourceRef();
            List list = rsrc.getProperty();
            for (PropertyType type : list) {
                if (!type.getPropertyName().equals(var.getPropertyName())) continue;
                type.setValue(this.ctxt.getVariable(var.getId()));
            }
        } else {
            String value = (String)this.handler.getPropertyValue(this.ctxt, (ResourceType)var.getResourceRef(), var.getPropertyName());
            if (value == null) {
                this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(ResourcePropertyType var):" + var.getId() + " - could not find a value for this resource.\n");
            } else {
                this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(ResourcePropertyType var):" + var.getId() + " - assigning value :" + value + "\n");
                this.ctxt.setVariable(var.getId(), this.ctxt.substituteVariables(value));
            }
        }
    }

    private String resolve(DerivedVariableType var) {
        String val;
        if (this.ctxt.containsVariable(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getName()) + " ::resolve:" + var.getId() + " - (" + this.ctxt.getVariable(String.valueOf(var.getId()) + ") already assigned\n"));
        } else if (var.getExpression() != null) {
            this.ctxt.setVariable(var.getId(), this.ctxt.substituteVariables(var.getExpression()));
        } else if (!var.getConditionalExpression().isEmpty() && (val = this.resolve(var.getConditionalExpression())) != null) {
            this.ctxt.setVariable(var.getId(), this.ctxt.substituteVariables(val));
        }
        return this.ctxt.getVariable(var.getId());
    }

    private String resolve(List<ConditionalDerivedVariableExpressionType> list) {
        ArrayList<Pair> exprs = new ArrayList<Pair>();
        for (ConditionalDerivedVariableExpressionType exp : list) {
            Pair p = this.resolve(exp);
            if (p == null) continue;
            exprs.add(p);
        }
        Pair p = this.getHighestPriority(exprs);
        if (p != null) {
            return p.expression;
        }
        return null;
    }

    private Pair resolve(ConditionalDerivedVariableExpressionType var) {
        if (var.getCondition() != null) {
            ConditionType cond = var.getCondition();
            for (ConditionalResourceConstraintType resCon : cond.getResourceConstraint()) {
                for (ConditionalPropertyConstraintType p : resCon.getPropertyConstraint()) {
                    if (!this.handler.evaluate(this.ctxt, (ResourceType)resCon.getResourceRef(), p)) continue;
                    String value = (String)this.handler.getPropertyValue(this.ctxt, (ResourceType)resCon.getResourceRef(), p.getPropertyName());
                    resCon.getOtherAttributes().put(p.getPropertyName(), value);
                    cond.getOtherAttributes().put(new QName("satisfied"), "true");
                    return new Pair(var.getPriority(), var.getExpression());
                }
            }
        }
        return null;
    }

    private void resolve(ParametersType params) {
        for (Object o : params.getIntegerParameterOrStringParameterOrBooleanParameter()) {
            Object obj = ((JAXBElement)o).getValue();
            if (obj instanceof BooleanParameterType) {
                this.resolve((BooleanParameterType)obj);
            }
            if (obj instanceof IntegerParameterType) {
                this.resolve((IntegerParameterType)obj);
            }
            if (obj instanceof StringParameterType) {
                this.resolve((StringParameterType)obj);
            }
            if (!(obj instanceof URIParameterType)) continue;
            this.resolve((URIParameterType)obj);
        }
    }

    private void resolve(URIParameterType var) {
        if (this.ctxt.containsParameter(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(URIParameterType var):" + var.getId() + " - (" + ((URIParameterType)this.ctxt.getParameter(var.getId())).getDefaultValue() + ") already assigned\n");
            return;
        }
        if (var.getDefaultValue() != null) {
            var.setDefaultValue(this.ctxt.substituteVariables(var.getDefaultValue()));
            this.log.log(3, "assigning URIParameterType " + var.getId() + " the default value of " + var.getDefaultValue());
            this.ctxt.setParameter(var, var.getId(), Boolean.valueOf(var.getDefaultValue() == null ? var.isRequired() : false), this.ctxt.getVariable(var.getId()));
            return;
        }
    }

    private void resolve(StringParameterType var) {
        if (this.ctxt.containsParameter(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(StringParameterType var):" + var.getId() + " - (" + ((StringParameterType)this.ctxt.getParameter(var.getId())).getDefaultValue() + ") already assigned\n");
            return;
        }
        if (var.getDefaultValue() != null) {
            var.setDefaultValue(this.ctxt.substituteVariables(var.getDefaultValue()));
            this.log.log(3, "assigning StringParameterType " + var.getId() + " the default value of " + var.getDefaultValue());
            this.ctxt.setParameter(var, var.getId(), Boolean.valueOf(var.getDefaultValue() == null ? var.isRequired() : false), this.ctxt.getVariable(var.getId()));
            return;
        }
    }

    private void resolve(IntegerParameterType var) {
        if (this.ctxt.containsParameter(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(IntegerParameterType var):" + var.getId() + " - (" + ((IntegerParameterType)this.ctxt.getParameter(var.getId())).getDefaultValue() + ") already assigned\n");
            return;
        }
        if (var.getDefaultValue() != null) {
            var.setDefaultValue(this.ctxt.substituteVariables(var.getDefaultValue()));
            this.log.log(3, "assigning IntegerParameterType " + var.getId() + " the default value of " + var.getDefaultValue());
            this.ctxt.setParameter(var, var.getId(), Boolean.valueOf(var.getDefaultValue() == null ? var.isRequired() : false), this.ctxt.getVariable(var.getId()));
            return;
        }
    }

    private void resolve(BooleanParameterType var) {
        if (this.ctxt.containsParameter(var.getId())) {
            this.log.log(3, String.valueOf(this.getClass().getSimpleName()) + " ::resolve(IntegerParameterType var):" + var.getId() + " - (" + ((BooleanParameterType)this.ctxt.getParameter(var.getId())).getDefaultValue() + ") already assigned\n");
            return;
        }
        if (var.getDefaultValue() != null) {
            var.setDefaultValue(this.ctxt.substituteVariables(var.getDefaultValue()));
            this.log.log(3, "assigning BooleanParameterType " + var.getId() + " the default value of " + var.getDefaultValue());
            this.ctxt.setParameter(var, var.getId(), Boolean.valueOf(var.getDefaultValue() == null ? var.isRequired() : false), this.ctxt.getVariable(var.getId()));
            return;
        }
    }

    private Pair getHighestPriority(List<Pair> list) {
        if (list.isEmpty()) {
            return null;
        }
        BigInteger i = BigInteger.ZERO;
        for (Pair p : list) {
            BigInteger j = p.priority;
            i = i.max(j);
        }
        for (Pair p : list) {
            if (!p.priority.equals(i)) continue;
            return p;
        }
        return null;
    }

    private class Pair {
        public BigInteger priority;
        public String expression;

        public Pair(BigInteger priority, String expression) {
            this.priority = priority;
            this.expression = expression;
        }
    }
}

