/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.cli.equinox;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class Op implements CommandProvider {
	private OperationHandler ophandler;

	public void setOperationHandlerByType(OperationHandler ophandler) {
		this.ophandler = ophandler;
	}
	
	public void unsetOperationHandlerByType(OperationHandler ophandler) {
		this.ophandler = null;
	}
	
	public void _op(CommandInterpreter ci) {
		String op = ci.nextArgument();
		String type = ci.nextArgument();
		if (op != null && type != null) {
			ArtifactType artifact = new ArtifactType();
			artifact.setType(new QName(type));
			ophandler.invokeAction(null, artifact, OperationType.fromValue(op));
		} else {
			ci.println("Usage:" + getHelp());
		}
	}

	public String getHelp() {
		return "\top (install|uninstall) <type>\n";
	}

}
