/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.op.impl;

import java.text.MessageFormat;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.op.IOperationHandler;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class OperationHandlerImpl implements OperationHandler {
	static final String QUERY = "(qname={0})";
	private BundleContext context;
	
	protected void activate(ComponentContext ctxt) {
		context = ctxt.getBundleContext();
	}
	
	protected void deactivate(ComponentContext ctxt) {
		context = null;
	}
	
	public void invokeAction(SDDContext ctxt, ArtifactType artifact, OperationType operation) {
		QName qname = null;
		if (artifact.getResourceRef() != null)
			qname = ((ResourceType)artifact.getResourceRef()).getType();
		else
			qname = artifact.getType();
		ServiceReference ref = getService(qname);
		if (ref != null) {
			IOperationHandler op = (IOperationHandler) context.getService(ref);
			op.invokeAction(ctxt, artifact, operation);
			context.ungetService(ref);
		}
	}
	
	public void invokeAction(SDDContext ctxt, ArtifactType artifact, AdditionalContentType content, OperationType operation) {
		QName qname = null;
		if (content.getType() != null)
			qname = content.getType();
		else
			qname = new QName("AdditionalContent");
		ServiceReference ref = getService(qname);
		if (ref != null) {
			IOperationHandler op = (IOperationHandler) context.getService(ref);
			op.invokeAction(ctxt, artifact, content, operation);
			context.ungetService(ref);
		}
	}
	
	private ServiceReference getService(QName qname) {
		ServiceReference ref = null;
		String query = MessageFormat.format(QUERY, qname.toString());
		try {
			ServiceReference[] refs = context.getServiceReferences(IOperationHandler.class.getName(), query);
			if (refs != null && refs.length > 0) {
				ref = refs[0];
			}
		} catch (InvalidSyntaxException e) {
			return null;
		}
		
		return ref;
	}

}
