/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener.event.impl;

import java.util.Dictionary;
import java.util.Properties;

import org.eclipse.cosmos.me.sdd.op.listener.EntryData;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationCompletion;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationProgress;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationRollback;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationSetup;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@SuppressWarnings("unchecked")
public class Broker implements InstallationCompletion, InstallationProgress, InstallationSetup, InstallationRollback {
	private EventAdmin eventAdmin;
	
	public void setEventAdmin(EventAdmin eventAdmin) {
		this.eventAdmin = eventAdmin;
	}
	
	public void unsetEventAdmin(EventAdmin eventAdmin) {
		this.eventAdmin = null;
	}
	
	/* InstallationCompletion */
	public void installationCancelled() {
		eventAdmin.postEvent(new Event(InstallationCompletion.Topic.CANCELLED.value(), (Dictionary)null));
	}

	public void installationComplete() {
		eventAdmin.postEvent(new Event(InstallationCompletion.Topic.COMPLETE.value(), (Dictionary)null));
	}

	public void installationFailure(String description) {
		Dictionary props = new Properties();
		props.put(InstallationCompletion.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationCompletion.Topic.FAILURE.value(), props));
	}

	/* InstallationProgress */
	public synchronized void bytesMoved(long numBytes) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.BYTES, numBytes);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.BYTES_MOVED.value(), props));
	}

	public void progressBeginningAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.ACTION, action);
		props.put(InstallationProgress.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.BEGINNING.value(), props));
	}

	public void progressBeginningAction(String description) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.BEGINNING.value(), props));
	}

	public void progressCompleteAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.ACTION, action);
		props.put(InstallationProgress.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.COMPLETE.value(), props));
	}

	public void progressCompleteAction(String description) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.COMPLETE.value(), props));
	}

	public void progressFailedAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationProgress.ACTION, action);
		props.put(InstallationProgress.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationProgress.Topic.FAILED.value(), props));
	}

	/* InstallationSetupListener */
	public void setupAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationSetup.ACTION, action);
		props.put(InstallationSetup.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationSetup.Topic.SETUP.value(), props));
	}

	public void setupAction(String description) {
		Dictionary props = new Properties();
		props.put(InstallationSetup.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationSetup.Topic.SETUP.value(), props));
	}

	/* InstallationRollbackListener */
	public void allRollbackCompleteAction() {
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.ALL_COMPLETE.value(), (Dictionary)null));
	}

	public void rollbackBytesMoved(long numBytes) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.BYTES, numBytes);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.BYTES_MOVED.value(), props));
	}

	public void rollbackFailure(String description) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.FAILURE.value(), props));
	}

	public void rollbackProgressBeginningAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.ACTION, action);
		props.put(InstallationRollback.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.BEGINNING.value(), props));
	}

	public void rollbackProgressBeginningAction(String description) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.BEGINNING.value(), props));
	}

	public void rollbackProgressCompleteAction(String action, EntryData metaData) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.ACTION, action);
		props.put(InstallationRollback.METADATA, metaData);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.COMPLETE.value(), props));
	}

	public void rollbackProgressCompleteAction(String description) {
		Dictionary props = new Properties();
		props.put(InstallationRollback.DESCRIPTION, description);
		eventAdmin.postEvent(new Event(InstallationRollback.Topic.COMPLETE.value(), props));
	}
	
}
