/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.CompletionType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ConditionCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.OperationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionCompare {
    protected static Collection<CompletionType> merge(List<CompletionType> c, List<CompletionType> c2) {
        Vector<CompletionType> toRemove = new Vector<CompletionType>();
        for (CompletionType o1 : c) {
            for (CompletionType o2 : c2) {
                if (toRemove.contains(o2) || !CompletionCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = CompletionCompare.merge(o1, o2);
            }
        }
        c2.removeAll(toRemove);
        Vector<CompletionType> finals = new Vector<CompletionType>();
        finals.addAll(c);
        finals.addAll(c2);
        return finals;
    }

    protected static CompletionType merge(CompletionType o1, CompletionType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        CompletionType merged = objectFactory.createCompletionType();
        merged.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        merged.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
        merged.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        merged.setType(o1.getType());
        merged.setResourceRef(o1.getResourceRef());
        merged.getOperation().addAll(o1.getOperation());
        merged.setCondition(ConditionCompare.merge(o1.getCondition(), o2.getCondition()));
        return merged;
    }

    protected static boolean equals(CompletionType c, CompletionType c2) {
        if (!StringCompare.equals(c.getType(), c2.getType())) {
            return false;
        }
        if (!ResourceCompare.equals((ResourceType)c.getResourceRef(), (ResourceType)c2.getResourceRef())) {
            return false;
        }
        return OperationCompare.equals(c.getOperation(), c2.getOperation());
    }
}

