/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import org.eclipse.cosmos.me.sdd.schema.IdentityType;
import org.eclipse.cosmos.me.sdd.schema.ManufacturerType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.BuildInformationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.MaintenanceInformationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ManufacturerCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

public class IdentityCompare {
    protected static IdentityType merge(IdentityType identity, IdentityType identity2) {
        if (IdentityCompare.equals(identity, identity2)) {
            ObjectFactory objectFactory = new ObjectFactory();
            IdentityType merged = objectFactory.createIdentityType();
            merged.setBuildInformation(BuildInformationCompare.merge(identity.getBuildInformation(), identity2.getBuildInformation()));
            merged.setDescription(DisplayTextCompare.merge(identity.getDescription(), identity2.getDescription()));
            merged.setMaintenanceInformation(MaintenanceInformationCompare.merge(identity.getMaintenanceInformation(), identity2.getMaintenanceInformation()));
            ManufacturerType m = ManufacturerCompare.merge(identity.getManufacturer(), identity2.getManufacturer());
            if (m == null) {
                return null;
            }
            merged.setManufacturer(m);
            merged.setName(DisplayTextCompare.merge(identity.getName(), identity2.getName()));
            merged.setShortDescription(DisplayTextCompare.merge(identity.getShortDescription(), identity2.getShortDescription()));
            merged.setSoftwareID(StringCompare.merge(identity.getSoftwareID(), identity2.getSoftwareID()));
            merged.setVersion(StringCompare.mergeVersion(identity.getVersion(), identity2.getVersion()));
            return merged;
        }
        return null;
    }

    protected static boolean equals(IdentityType identity, IdentityType identity2) {
        return StringCompare.equals(identity.getSoftwareID(), identity2.getSoftwareID());
    }
}

