/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.OperationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIParameterCompare {
    protected static Vector<URIParameterType> merge(List<URIParameterType> params, List<URIParameterType> params2) {
        Vector<URIParameterType> toRemove = new Vector<URIParameterType>();
        for (URIParameterType o1 : params) {
            for (URIParameterType o2 : params2) {
                if (toRemove.contains(o2) || !URIParameterCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = URIParameterCompare.merge(o1, o2);
            }
        }
        params2.removeAll(toRemove);
        Vector<URIParameterType> finals = new Vector<URIParameterType>();
        finals.addAll(params);
        finals.addAll(params2);
        return finals;
    }

    private static boolean equals(URIParameterType o1, URIParameterType o2) {
        if (!StringCompare.equals(o1.getDefaultValue(), o2.getDefaultValue())) {
            return false;
        }
        if (o1.isSensitive() != o2.isSensitive()) {
            return false;
        }
        if (o1.isRequired() != o2.isRequired()) {
            return false;
        }
        return !OperationCompare.equals(o1.getOperation(), o2.getOperation());
    }

    protected static URIParameterType merge(URIParameterType string1, URIParameterType string2) {
        ObjectFactory objectFactory = new ObjectFactory();
        URIParameterType merged = objectFactory.createURIParameterType();
        merged.setDisplayName(DisplayTextCompare.merge(string1.getDisplayName(), string2.getDisplayName()));
        merged.setDescription(DisplayTextCompare.merge(string1.getDescription(), string2.getDescription()));
        return merged;
    }
}

