/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SDDManagerImpl;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SDD_DASImpl;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.sdd.tests.common.validation.AllTests;
import org.eclipse.cosmos.me.sdd.tests.common.validation.TrivialValidationRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDDManagerImpl_Test
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        AllTests.copySchemaFiles();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddDescriptorFromFile_ValidDD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Collection<Document> documents = manager.getDeploymentDescriptors();
        SDDManagerImpl_Test.assertNotNull((Object)documents.toArray(new Document[0])[0]);
    }

    public void testAddDescriptorFromFile_MalformedDD() throws FileNotFoundException, IOException {
        SDDManagerImpl manager = new SDDManagerImpl();
        try {
            manager.addDescriptorFromFile(new File(AllTests.MALFORMED_DD));
            SDDManagerImpl_Test.fail((String)"DD file is malformed but an XMLValidationException was not thrown");
        }
        catch (XMLValidationException xMLValidationException) {}
    }

    public void testAddDescriptorFromDocument_ValidDD() throws IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        SDD_DASImpl sddDas = new SDD_DASImpl();
        Document doc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        manager.addDescriptorFromDocument(doc, new File(AllTests.VALID_DD));
        Collection<Document> ddDocs = manager.getDeploymentDescriptors();
        SDDManagerImpl_Test.assertSame((Object)doc, (Object)ddDocs.toArray(new Document[0])[0]);
        Collection<Document> allDocs = manager.getAllDescriptors();
        SDDManagerImpl_Test.assertSame((Object)doc, (Object)allDocs.toArray(new Document[0])[0]);
    }

    public void testAddDescriptorFromFile_ValidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Collection<Document> docs = manager.getPackageDescriptors();
        SDDManagerImpl_Test.assertNotNull((Object)docs.toArray(new Document[0])[0]);
    }

    public void testAddDescriptorFromFile_InvalidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Collection<Document> docs = manager.getPackageDescriptors();
        SDDManagerImpl_Test.assertNotNull((Object)docs.toArray(new Document[0])[0]);
    }

    public void testAddDescriptorFromDocument_ValidPD() throws IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        SDD_DASImpl sddDas = new SDD_DASImpl();
        Document doc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        manager.addDescriptorFromDocument(doc, new File(AllTests.VALID_PD));
        Collection<Document> docs = manager.getPackageDescriptors();
        SDDManagerImpl_Test.assertSame((Object)doc, (Object)docs.toArray(new Document[0])[0]);
    }

    public void testAddValidation_DD() {
        SDDManagerImpl manager = new SDDManagerImpl();
        int i = 0;
        while (i < 1000) {
            TrivialValidationRule validationRule = new TrivialValidationRule();
            manager.addValidation(validationRule, 1);
            ++i;
        }
        Collection<ValidationRule> ddRules = manager.getDeploymentDescriptorRules();
        SDDManagerImpl_Test.assertEquals((int)ddRules.size(), (int)1000);
        Collection<ValidationRule> allRules = manager.getAllValidationRules();
        SDDManagerImpl_Test.assertEquals((int)allRules.size(), (int)1000);
        Collection<ValidationRule> pdRules = manager.getPackageDescriptorRules();
        SDDManagerImpl_Test.assertEquals((int)pdRules.size(), (int)0);
    }

    public void testAddValidation_PD() {
        SDDManagerImpl manager = new SDDManagerImpl();
        int i = 0;
        while (i < 1000) {
            TrivialValidationRule validationRule = new TrivialValidationRule();
            manager.addValidation(validationRule, 2);
            ++i;
        }
        Collection<ValidationRule> pdRules = manager.getPackageDescriptorRules();
        SDDManagerImpl_Test.assertEquals((int)pdRules.size(), (int)1000);
        Collection<ValidationRule> allRules = manager.getAllValidationRules();
        SDDManagerImpl_Test.assertEquals((int)allRules.size(), (int)1000);
        Collection<ValidationRule> ddRules = manager.getDeploymentDescriptorRules();
        SDDManagerImpl_Test.assertEquals((int)ddRules.size(), (int)0);
    }

    public void testRemoveValidation_DD() {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addValidation(new TrivialValidationRule(), 1);
        manager.removeValidation(manager.getAllValidationRules().toArray(new ValidationRule[0])[0], 1);
        SDDManagerImpl_Test.assertEquals((int)manager.getAllValidationRules().size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)manager.getDeploymentDescriptorRules().size(), (int)0);
    }

    public void testRemoveValidation_PD() {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addValidation(new TrivialValidationRule(), 2);
        manager.removeValidation(manager.getAllValidationRules().toArray(new ValidationRule[0])[0], 2);
        SDDManagerImpl_Test.assertEquals((int)manager.getAllValidationRules().size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)manager.getDeploymentDescriptorRules().size(), (int)0);
    }

    public void testRemoveDescriptors() {
        SDDManagerImpl manager = new SDDManagerImpl();
        TrivialValidationRule trivialRule = new TrivialValidationRule();
        TrivialValidationRule schemaRule = new TrivialValidationRule();
        manager.addValidation(trivialRule, 1);
        manager.addValidation(schemaRule, 2);
        manager.removeValidation(trivialRule, 1);
        SDDManagerImpl_Test.assertEquals((int)manager.getAllValidationRules().size(), (int)1);
        SDDManagerImpl_Test.assertEquals((int)manager.getDeploymentDescriptorRules().size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)manager.getPackageDescriptorRules().size(), (int)1);
        manager.removeValidation(schemaRule, 2);
        SDDManagerImpl_Test.assertEquals((int)manager.getAllValidationRules().size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)manager.getDeploymentDescriptorRules().size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)manager.getPackageDescriptorRules().size(), (int)0);
    }

    public void testValidateAllDescriptors_Valid() throws XMLValidationException, FileNotFoundException, IOException {
        SDDManagerImpl manager = new SDDManagerImpl();
        manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Collection<XMLValidationError> validationErrors = manager.validateAllDescriptors();
        SDDManagerImpl_Test.assertEquals((int)validationErrors.size(), (int)0);
    }

    public void testValidateAllDescriptors_Invalid() throws XMLValidationException, FileNotFoundException, IOException {
        SDDManagerImpl manager = new SDDManagerImpl();
        Document ddDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Document pdDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Element resourceElement = ValidatorUtils.findElement(ddDoc, "Resource");
        resourceElement.getParentNode().removeChild(resourceElement);
        Element contentElement = ValidatorUtils.findElement(pdDoc, "Content");
        contentElement.getParentNode().removeChild(contentElement);
        Collection<XMLValidationError> validationErrors = manager.validateAllDescriptors();
        SDDManagerImpl_Test.assertTrue((validationErrors.size() > 0 ? 1 : 0) != 0);
    }

    public void testValidateDescriptors_ValidDD_ValidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        Document ddDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Document pdDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Collection<XMLValidationError> ddValidationErrors = manager.validateDescriptors(Arrays.asList(ddDoc));
        Collection<XMLValidationError> pdValidationErrors = manager.validateDescriptors(Arrays.asList(pdDoc));
        SDDManagerImpl_Test.assertEquals((int)ddValidationErrors.size(), (int)0);
        SDDManagerImpl_Test.assertEquals((int)pdValidationErrors.size(), (int)0);
    }

    public void testValidateDescriptors_ValidDD_InvalidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        Document ddDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Document pdDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Element contentElement = ValidatorUtils.findElement(pdDoc, "Contents");
        contentElement.getParentNode().removeChild(contentElement);
        Collection<XMLValidationError> ddValidationErrors = manager.validateDescriptors(Arrays.asList(ddDoc));
        Collection<XMLValidationError> pdValidationErrors = manager.validateDescriptors(Arrays.asList(pdDoc));
        SDDManagerImpl_Test.assertEquals((int)ddValidationErrors.size(), (int)0);
        SDDManagerImpl_Test.assertTrue((pdValidationErrors.size() > 0 ? 1 : 0) != 0);
    }

    public void testValidateDescriptors_InvalidDD_InvalidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        Document ddDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Document pdDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Element resourceElement = ValidatorUtils.findElement(ddDoc, "Resource");
        resourceElement.getParentNode().removeChild(resourceElement);
        Element contentElement = ValidatorUtils.findElement(pdDoc, "Contents");
        contentElement.getParentNode().removeChild(contentElement);
        Collection<XMLValidationError> ddValidationErrors = manager.validateDescriptors(Arrays.asList(ddDoc));
        Collection<XMLValidationError> pdValidationErrors = manager.validateDescriptors(Arrays.asList(pdDoc));
        SDDManagerImpl_Test.assertTrue((ddValidationErrors.size() > 0 ? 1 : 0) != 0);
        SDDManagerImpl_Test.assertTrue((pdValidationErrors.size() > 0 ? 1 : 0) != 0);
    }

    public void testValidateDescriptors_InvalidDD_ValidPD() throws FileNotFoundException, IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        Document ddDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_DD));
        Document pdDoc = manager.addDescriptorFromFile(new File(AllTests.VALID_PD));
        Element resourceElement = ValidatorUtils.findElement(ddDoc, "Resource");
        resourceElement.getParentNode().removeChild(resourceElement);
        Collection<XMLValidationError> ddValidationErrors = manager.validateDescriptors(Arrays.asList(ddDoc));
        Collection<XMLValidationError> pdValidationErrors = manager.validateDescriptors(Arrays.asList(pdDoc));
        SDDManagerImpl_Test.assertTrue((ddValidationErrors.size() > 0 ? 1 : 0) != 0);
        SDDManagerImpl_Test.assertEquals((int)pdValidationErrors.size(), (int)0);
    }

    public void testWriteAllDescriptors() throws IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        File validDdOutput = File.createTempFile("DeploymentDescriptor", "xml");
        File validPdOutput = File.createTempFile("PackageDescriptor", "xml");
        validDdOutput.deleteOnExit();
        validPdOutput.deleteOnExit();
        SDD_DASImpl sddDas = new SDD_DASImpl();
        Document ddDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        Document pdDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        manager.addDescriptorFromDocument(ddDoc, validDdOutput);
        manager.addDescriptorFromDocument(pdDoc, validPdOutput);
        manager.writeAllDescriptors(false);
        if (new FileInputStream(validDdOutput).available() == 0) {
            SDDManagerImpl_Test.fail((String)"SDDManager failed to write Deployment Descriptor");
        }
        if (new FileInputStream(validPdOutput).available() == 0) {
            SDDManagerImpl_Test.fail((String)"SDDManager failed to write Package Descriptor");
        }
    }

    public void testWriteDescriptors_NotInManager() throws IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        File validDdOutput = File.createTempFile("DeploymentDescriptor", "xml");
        File validPdOutput = File.createTempFile("PackageDescriptor", "xml");
        File anotherOutput = File.createTempFile("Empty", "xml");
        validDdOutput.deleteOnExit();
        validPdOutput.deleteOnExit();
        anotherOutput.deleteOnExit();
        SDD_DASImpl sddDas = new SDD_DASImpl();
        Document ddDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        Document pdDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        Document anotherDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        manager.addDescriptorFromDocument(ddDoc, validDdOutput);
        manager.addDescriptorFromDocument(pdDoc, validPdOutput);
        manager.writeDescriptors(Arrays.asList(anotherDoc), false);
        if (new FileInputStream(anotherOutput).available() > 0) {
            SDDManagerImpl_Test.fail((String)"SDDManager wrote Descriptor that was not added to the manager");
        }
    }

    public void testWriteDescriptors_InManager() throws IOException, XMLValidationException {
        SDDManagerImpl manager = new SDDManagerImpl();
        File validDdOutput = File.createTempFile("DeploymentDescriptor", "xml");
        File validPdOutput = File.createTempFile("PackageDescriptor", "xml");
        validDdOutput.deleteOnExit();
        validPdOutput.deleteOnExit();
        SDD_DASImpl sddDas = new SDD_DASImpl();
        Document ddDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        Document pdDoc = sddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        manager.addDescriptorFromDocument(ddDoc, validDdOutput);
        manager.addDescriptorFromDocument(pdDoc, validPdOutput);
        manager.writeDescriptors(Arrays.asList(ddDoc), false);
        if (new FileInputStream(validDdOutput).available() == 0) {
            SDDManagerImpl_Test.fail((String)"SDDManager failed to write a Descriptor that was in the list of Descriptors to write");
        }
        if (new FileInputStream(validPdOutput).available() > 0) {
            SDDManagerImpl_Test.fail((String)"SDDManager wrote Descriptor that was not in the list of Descriptors to write");
        }
    }
}

