/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.common.validation;

import java.util.Collection;

import org.w3c.dom.Document;

/**
 * 
 * @author Eric S. Rose (esrose@us.ibm.com)
 *
 */
public interface SDD_DAS extends XML_DAS {
	public static final String DD_ROOT_ELEMENT = "DeploymentDescriptor"; //$NON-NLS-1$
	public static final String PD_ROOT_ELEMENT = "PackageDescriptor"; //$NON-NLS-1$
	public static final String DD_ROOT_URI = "http://docs.oasis-open.org/sdd/ns/deploymentDescriptor"; //$NON-NLS-1$
	public static final String PD_ROOT_URI = "http://docs.oasis-open.org/sdd/ns/packageDescriptor"; //$NON-NLS-1$
	
	/**
	 * Run all validation rules associated with the DAS instance.
	 * Always includes a SchemaValidationRule containing the SDD Schema.
	 *
	 * @param document Document to validate
	 * 
	 * @return A Collection of XMLValidationErrors, or an empty list if no error occurred
	 * 
	 * @throws IllegalArgumentException if the Document isn't a Deployment Descriptor or Package Descriptor
	 */
	Collection<XMLValidationError> validate(Document document) throws IllegalArgumentException;	
}