/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator;

import org.w3c.dom.Element;


public class AggregationError {
	public static final int ERROR = 1;
	public static final int WARNING = 2;
	
	private String message;
	private int severity;
	private Element elementOne;
	private Element elementTwo;
	
	/**
	 * Create an AggregationError with the given message and severity
	 * @param message Error message
	 * @param severity Severity of the error
	 */
	public AggregationError(String message, int severity) {
		this(message, severity, null, null);
	}
	
	/**
	 * Create an AggregationError with the given message and severity of ERROR
	 * @param message Error message
	 */
	public AggregationError(String message) {
		this(message, ERROR, null, null);
	}
	
	/**
	 * Create an AggregationError with the given message and DataObjects, and severity of ERROR
	 * @param message Error message
	 * @param objectOne First DataObject being merged when error occurred
	 * @param objectTwo Second DataObject being merged when error occurred
	 */
	public AggregationError(String message, Element elementOne, Element elementTwo) {
		this(message, ERROR, elementOne, elementTwo);
	}
	
	/**
	 * Create an AggregationError with the given message, severity and DataObjects
	 * @param message Error message
	 * @param severity Severity of the error
	 * @param objectOne First DataObject being merged when error occurred
	 * @param objectTwo Second DataObject being merged when error occurred
	 */
	public AggregationError(String message, int severity, Element elementOne, Element elementTwo) {
		this.message = message;
		this.severity = severity;
		this.elementOne = elementOne;
		this.elementTwo = elementTwo;
	}
	
	/**
	 * @return Error message
	 */
	public String getMessage() {
		return (message);
	}
	
	/**
	 * @return Severity of the error
	 */
	public int getSeverity() {
		return (severity);
	}
	
	/**
	 * @return First Element being merged when error occurred
	 */
	public Element getObjectOne() {
		return elementOne;
	}
	
	/**
	 * @return Second Element being merged when error occurred
	 */
	public Element getObjectTwo() {
		return elementTwo;
	}
}
