/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.DMJ2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.osgi.framework.Bundle;

public final class J2EEUtilities {
    public static final String META_INF_FOLDER_NAME = "META-INF";

    public static IFolder getWebInfLibDir(IProject project) {
        IVirtualFolder vf = J2EEUtilities.getWebInfSubdir(project, "lib");
        return (IFolder)vf.getUnderlyingFolder();
    }

    public static IFolder getWebInfServicesDir(IProject project) {
        IVirtualFolder vf = J2EEUtilities.getWebInfSubdir(project, "services");
        return (IFolder)vf.getUnderlyingFolder();
    }

    public static IFolder getWebInfClassesDir(IProject project) throws CoreException {
        IFolder lib = J2EEUtilities.getWebInfLibDir(project);
        IFolder classesFolder = ((IFolder)lib.getParent()).getFolder("classes");
        if (!classesFolder.exists()) {
            classesFolder.create(true, true, null);
        }
        return classesFolder;
    }

    protected static IVirtualFolder getWebInfSubdir(IProject pj, String subdir) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)pj);
        IVirtualFolder vf = vc.getRootFolder().getFolder("WEB-INF/" + subdir);
        return vf;
    }

    public static void copyBundle(String bundleName, IFolder dest) throws CoreException {
        try {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                throw new CoreException(DMJ2EEPlugin.createErrorStatus(NLS.bind((String)"Required bundle {0} is missing.", (Object)bundleName)));
            }
            File file = FileLocator.getBundleFile((Bundle)bundle);
            if (file.isDirectory()) {
                throw new CoreException(DMJ2EEPlugin.createErrorStatus(NLS.bind((String)"Bundle {0} is a directory.  This bundle must not exist in the workspace, but instead should be a jar file in the plugins directory.", (Object)bundleName)));
            }
            IFile destFile = dest.getFile(file.getName());
            if (!destFile.exists()) {
                FileInputStream in = new FileInputStream(file);
                destFile.create((InputStream)in, true, null);
            }
        }
        catch (IOException e) {
            throw DMJ2EEPlugin.createCoreException(e);
        }
    }

    public static void copyFromPlugin(Bundle bundle, IPath sourceFile, IFolder dest) throws CoreException {
        try {
            IFile destFile = dest.getFile(sourceFile.lastSegment());
            if (!destFile.exists()) {
                InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)sourceFile, (boolean)false);
                destFile.create(in, true, null);
            }
        }
        catch (IOException e) {
            throw DMJ2EEPlugin.createCoreException(e);
        }
    }

    public static String getDataManagerInitializerContents(IProjectConfig config) throws CoreException {
        String[] substitutionMap = new String[]{"%PACKAGE_DECLARATION%", J2EEUtilities.getPackageDeclaration(config), "%INITIALIZER_CLASS%", J2EEUtilities.getInitializerClassName(config), "%DATA_MANAGER_CLASS%", config.getName()};
        String resourceLocation = "resources/initializerSourceTemplate.txt";
        return J2EEUtilities.populateResourceTemplate(substitutionMap, resourceLocation);
    }

    public static String populateResourceTemplate(String[] substitutionMap, String resourceLocation) throws CoreException {
        return Utilities.populateResourceTemplate((String[])substitutionMap, (String)resourceLocation, (Bundle)DMJ2EEPlugin.getDefault().getBundle());
    }

    protected static String getPackageDeclaration(IProjectConfig config) {
        return "".equals(config.getPackageName()) ? "" : "package " + config.getPackageName() + ";";
    }

    public static String getInitializerClassName(IProjectConfig projectConfig) {
        return String.valueOf(projectConfig.getName()) + "Initializer";
    }
}

