/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;

public class ContentSelector
implements IContentSelector {
    private static final boolean DEFAULT_MATCHED_RECORDS = true;
    private List<ISelectedRecordType> selectedRecordTypes = new ArrayList<ISelectedRecordType>();
    private Boolean matchedRecords = null;

    public ISelectedRecordType[] getSelectedRecordTypes() {
        return this.selectedRecordTypes.toArray(new ISelectedRecordType[this.selectedRecordTypes.size()]);
    }

    public void addSelectedRecordType(ISelectedRecordType selectedRecordType) {
        this.selectedRecordTypes.add(selectedRecordType);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:contentSelector");
        if (this.matchedRecords != null) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"matchedRecords", (String)this.matchedRecords.toString());
        }
        writer.write(">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.selectedRecordTypes);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"cmdbf:contentSelector")) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.matchedRecords == null ? 0 : this.matchedRecords.hashCode());
        result = 31 * result + (this.selectedRecordTypes == null ? 0 : this.selectedRecordTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentSelector other = (ContentSelector)obj;
        if (this.matchedRecords == null ? other.matchedRecords != null : !this.matchedRecords.equals(other.matchedRecords)) {
            return false;
        }
        return !(this.selectedRecordTypes == null ? other.selectedRecordTypes != null : !this.selectedRecordTypes.equals(other.selectedRecordTypes));
    }

    public boolean isMatchedRecords() {
        return this.matchedRecords == null ? true : this.matchedRecords;
    }

    public void setMatchedRecords(boolean matchedRecords) {
        this.matchedRecords = matchedRecords;
    }
}

