/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.stat.datamgr;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.Parameter;
import org.apache.log4j.Logger;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.stat.datamgr.Messages;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalDataManager {
    private int _dset_id;
    private Logger logger = Logger.getLogger(this.getClass());
    private String namespace = "http://org.eclipse.cosmos.dc.stat.datamgr";
    private String _derby_home = null;

    public void init(ServiceContext serviceContext) {
        Parameter p = serviceContext.getAxisService().getParameter("derby.system.home");
        if (p != null) {
            this._derby_home = (String)p.getValue();
        }
    }

    public OMElement getStatDataForSources(OMElement input) throws CosmosException {
        String dataset = null;
        String keyset = null;
        int start = 0;
        int size = 0;
        Iterator childIter = input.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (elem.getLocalName().equals("dataset")) {
                dataset = elem.getText();
            }
            if (elem.getLocalName().equals("keyset")) {
                keyset = elem.getText();
            }
            if (elem.getLocalName().equals("start")) {
                start = Integer.parseInt(elem.getText());
            }
            if (!elem.getLocalName().equals("size")) continue;
            size = Integer.parseInt(elem.getText());
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        OMElement method = fac.createOMElement("getStatDataForSourcesResponse", omNs);
        this.SDFS(method, dataset, keyset, start, size);
        return method;
    }

    public OMElement getDatasourceKeysets(OMElement input) throws CosmosException {
        boolean i = false;
        Object tstr = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        OMElement method = fac.createOMElement("getDatasourceKeysets", omNs);
        Vector<DataSourceKeyset> keysets = this.getSources();
        if (keysets == null) {
            OMElement value = fac.createOMElement("Error", omNs);
            value.addChild((OMNode)fac.createOMText((OMContainer)value, Messages.getString("SOURCE_PROBLEM_ERR")));
            method.addChild((OMNode)value);
        } else {
            for (DataSourceKeyset ds : keysets) {
                String v = ds.getDataSet();
                String k = ds.getKeySet();
                OMElement value = fac.createOMElement("Dataset", omNs);
                value.addChild((OMNode)fac.createOMText((OMContainer)value, v));
                method.addChild((OMNode)value);
                value = fac.createOMElement("Keyset", omNs);
                value.addChild((OMNode)fac.createOMText((OMContainer)value, k));
                method.addChild((OMNode)value);
            }
        }
        return method;
    }

    private Connection getConnection() {
        Connection conn = null;
        Object[] urlArgs = new Object[]{"dummy"};
        String url = MessageFormat.format("jdbc:derby:cosmosdb;create=true", urlArgs);
        Driver d = null;
        this.logger.debug((Object)("derby " + this._derby_home));
        System.setProperty("derby.system.home", this._derby_home);
        try {
            d = (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            DriverManager.registerDriver(d);
            conn = DriverManager.getConnection(url);
            DriverManager.deregisterDriver(d);
        }
        catch (Exception ex) {
            this.logger.error((Object)MessageFormat.format(Messages.getString("ECONNECT_ERR"), url));
            this.logger.debug((Object)MessageFormat.format(Messages.getString("CONNECTION_DEBUG"), ex.getMessage()));
            return null;
        }
        this.logger.info((Object)MessageFormat.format(Messages.getString("CONNECT_INFO"), url));
        return conn;
    }

    private Vector<DataSourceKeyset> getSources() throws CosmosException {
        Connection conn = null;
        Vector<String> vn = null;
        Vector<Integer> vid = null;
        Vector<DataSourceKeyset> kn = null;
        Object Iv = null;
        Object Ik = null;
        Object v = null;
        Object k = null;
        Object ret = null;
        boolean idx = false;
        Object ds = null;
        vn = new Vector<String>();
        vid = new Vector<Integer>();
        kn = new Vector<DataSourceKeyset>();
        conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        this.fillInDataSets(conn, vn, vid);
        this.fillInKeySets(conn, vn, vid, kn);
        return kn;
    }

    private void fillInKeySets(Connection conn, Vector<String> vn, Vector<Integer> vid, Vector<DataSourceKeyset> kn) {
        Object rs = null;
        Object stmt = null;
        Object query = null;
        Iterator<Integer> It = null;
        Iterator<String> Itv = null;
        Object Itk = null;
        Integer itmp = null;
        int ivalue = 0;
        Object kid = null;
        boolean id = false;
        String s = null;
        Object I = null;
        DataSourceKeyset ds = null;
        String v = null;
        It = vid.iterator();
        Itv = vn.iterator();
        while (It.hasNext()) {
            itmp = It.next();
            ivalue = itmp;
            v = Itv.next();
            s = this.getKeySetName(conn, itmp);
            ds = new DataSourceKeyset(v, s);
            kn.add(ds);
        }
    }

    private void fillInDataSets(Connection conn, Vector<String> vn, Vector<Integer> vid) {
        ResultSet rs = null;
        Statement stmt = null;
        String query = new String("select * from COSMOS_STAT.STATISTICAL_DATASET");
        rs = this.DoQuery(conn, query);
        try {
            while (rs.next()) {
                String name = rs.getString("NAME");
                if (name == null) {
                    name = new String("<NULL>");
                }
                vn.add(name);
                int id = rs.getInt("ID");
                Integer I = new Integer(id);
                vid.add(I);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)MessageFormat.format(Messages.getString("RETRIEVAL_ERR"), ex.getMessage()));
            return;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex2) {
            this.logger.error((Object)Messages.getString("CLOSE_ERR"));
            return;
        }
    }

    private ResultSet DoQuery(Connection conn, String query) {
        Statement stmt = null;
        ResultSet ret = null;
        this.logger.debug((Object)MessageFormat.format(Messages.getString("QUERY_TEST_DEBUG"), query));
        try {
            stmt = conn.createStatement();
            ret = stmt.executeQuery(query);
        }
        catch (Exception e) {
            this.logger.error((Object)MessageFormat.format(Messages.getString("SQL_ERR"), e.getMessage()));
            return null;
        }
        this.logger.debug((Object)MessageFormat.format(Messages.getString("QUERY_OK_DEBUG"), query));
        return ret;
    }

    private String getKeySetName(Connection conn, int id) {
        ResultSet rs = null;
        String ret = null;
        String query = new String("select NAME from COSMOS.KEY_SET where ID = " + id);
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            ret = rs.getString("NAME");
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getString("ID_ERROR"));
            return null;
        }
        return ret;
    }

    private void SDFS(OMElement elem, String dataset, String keyset, int start, int size) throws CosmosException {
        Connection conn = null;
        this._dset_id = 0;
        conn = this.getConnection();
        if (conn == null) {
            return;
        }
        this.SetDSetId(dataset);
        this.DoObservation(elem, conn, start, size);
    }

    private void SetDSetId(String lookup) throws CosmosException {
        Connection conn = null;
        ResultSet rs = null;
        String query = null;
        conn = this.getConnection();
        if (conn == null) {
            return;
        }
        query = new String("select ID from COSMOS_STAT.STATISTICAL_DATASET where NAME = '" + lookup + "'");
        rs = this.DoQuery(conn, query);
        try {
            rs.next();
            this._dset_id = rs.getInt("ID");
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getString("ID_ERROR"));
        }
    }

    private void DoObservation(OMElement elem, Connection conn, int start, int size) {
        ResultSet rs = null;
        Statement stmt = null;
        String query = null;
        int cnt = 0;
        int idx = 0;
        long l = 0L;
        double db = 0.0;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(this.namespace, "ns");
        query = new String("select * from COSMOS_STAT.STATISTICAL_OBSERVATION where DATA_SET_ID = " + this._dset_id + " and KEY_ENTRY = 3");
        rs = this.DoQuery(conn, query);
        try {
            while (rs.next()) {
                if (idx >= start) {
                    Timestamp d = rs.getTimestamp("CAPTURE_TIME");
                    OMElement value = fac.createOMElement("CAPTURE_TIME", omNs);
                    value.addChild((OMNode)fac.createOMText((OMContainer)value, d.toString()));
                    elem.addChild((OMNode)value);
                    String svalue = rs.getString("STRING_VALUE");
                    if (svalue == null) {
                        l = rs.getLong("INTEGRAL_VALUE");
                        if (l == 0L) {
                            db = rs.getDouble("DECIMAL_VALUE");
                            value = fac.createOMElement("DECIMAL_VALUE", omNs);
                            value.addChild((OMNode)fac.createOMText((OMContainer)value, String.valueOf(db)));
                            elem.addChild((OMNode)value);
                        } else {
                            value = fac.createOMElement("INTEGRAL_VALUE", omNs);
                            value.addChild((OMNode)fac.createOMText((OMContainer)value, String.valueOf(l)));
                            elem.addChild((OMNode)value);
                        }
                    } else {
                        value = fac.createOMElement("STRING_VALUE", omNs);
                        value.addChild((OMNode)fac.createOMText((OMContainer)value, svalue));
                        elem.addChild((OMNode)value);
                    }
                    ++cnt;
                }
                ++idx;
                if (cnt != size) continue;
                break;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)MessageFormat.format(Messages.getString("RETRIEVAL_ERR"), ex.getMessage()));
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex2) {
            this.logger.error((Object)Messages.getString("CLOSE_ERR"));
        }
    }
}

