/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.provisional.datamodel;

import java.util.Iterator;
import java.util.Properties;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.cosmos.dc.provisional.datamanager.*;

/**
 * An object that describes a group of web services.
 *
 */
public class Group {
	private String host;
	private Services services = new Services();
	private ConfigurationManager _config = new ConfigurationManager();
	
	public Properties getProperties() { return _config.getOtherProperties(); }
	/**
	 * @return the name
	 */
	public String getName() {
		String n = _config.getDisplayName();
		return (n == null) ? null : n.trim();
	}
	
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this._config.setDisplayName(name);
	}
	
	/**
	 * @return the description
	 */
	public String getDescription() {
		String n = _config.getDescription();
		return (n == null) ? null : n.trim();
	}
	
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this._config.setDescription(description);
	}
	
	/**
	 * @return the id
	 */
	public String getId() {
		String n = _config.getId();
		return (n == null) ? null : n.trim();
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this._config.setId(id);
	}

	/**
	 * @return the soapNamespace
	 */
	public String getSoapNamespace() {
		String n = _config.getSoapNamespace();
		return (n == null) ? null : n.trim(); 
	}

	/**
	 * @param soapNamespace the soapNamespace to set
	 */
	public void setSoapNamespace(String soapNamespace) {
		this._config.setSoapNamespace(soapNamespace);
	}

	/**
	 * @return the recordTypeNamespace
	 */
	public String getRecordTypeNamespace() {
		String n = _config.getRecordTypeNamespace();
		return (n == null) ? null : n.trim();
	}

	/**
	 * @param recordTypeNamespace the recordTypeNamespace to set
	 */
	public void setRecordTypeNamespace(String recordTypeNamespace) {
		this._config.setRecordTypeNamespace(recordTypeNamespace);
	}

	/**
	 * @return the securityNamespace
	 */
	public String getSecurityNamespace() {
		String n = _config.getSecurityNamespace();
		return (n == null) ? null : n.trim();
	}

	/**
	 * @param securityNamespace the securityNamespace to set
	 */
	public void setSecurityNamespace(String securityNamespace) {
		this._config.setSecurityNamespace(securityNamespace);
	}

	/**
	 * @return the host
	 */
	public String getHost() {
		return (host==null) ? null : host.trim();
	}
	
	/**
	 * @param id the id to set
	 */
	public void setHost(String host) {
		this.host = host;
	}
	
	
	
	/**
	 * @return the services
	 */
	public Services getServices() {
		return services;
	}
	
	/**
	 * @param services the services to set
	 */
	public void setServices(Services services) {
		this.services = services;
	}
	
	
	
	
	public OMElement toOM() {
        String hostid = getHost();
    	String desc = getDescription();
    	String name = getName();
    	String id = getId();
    	String sns = getSoapNamespace();
    	String rtns = getRecordTypeNamespace();
    	String secns = getSecurityNamespace();
    	
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        
        // TODO: move element names to constant file.
    	OMElement groupxml = fac.createOMElement("group", omNs);
    	OMElement hostxml = fac.createOMElement("host", omNs, groupxml);
    	OMElement descxml = fac.createOMElement("description", omNs, groupxml);
    	OMElement namexml = fac.createOMElement("name", omNs, groupxml);
    	OMElement idxml = fac.createOMElement("id", omNs, groupxml);
    	OMElement soapNamespacexml = fac.createOMElement("soapNamespace", omNs, groupxml);
    	OMElement recordTypeNamespacexml = fac.createOMElement("recordTypeNamespace", omNs, groupxml);
    	OMElement securityNamespacexml = fac.createOMElement("securityNamespace", omNs, groupxml);
    	
    	fac.createOMText(hostxml, hostid);
    	fac.createOMText(descxml, desc);
    	fac.createOMText(namexml, name);
    	fac.createOMText(idxml, id);
    	fac.createOMText(soapNamespacexml, sns);
    	fac.createOMText(recordTypeNamespacexml, rtns);
    	fac.createOMText(securityNamespacexml, secns);
    	
    	if (getServices() != null) {
    		groupxml.addChild(getServices().toOM());
    	}

    	return groupxml;
	}
	
			
	public static Group getGroup(OMElement groupxml) { 
		Group group = new Group();
		String p = null;
		String t = null;
		
		Iterator groupIter = groupxml.getChildElements();
		while (groupIter.hasNext()) {
			OMElement elem = (OMElement) groupIter.next();
					
			if (elem.getLocalName().equals("host")) {
				group.setHost(elem.getText());
			} else if (elem.getLocalName().equals("name")) {
				group.setName(elem.getText());
			} else if (elem.getLocalName().equals("description")) {
				group.setDescription(elem.getText());
			} else if (elem.getLocalName().equals("services")) {
				group.setServices(Services.getServices(elem));
			} else if (elem.getLocalName().equals("id")) {
				group.setId(elem.getText());
			} else if (elem.getLocalName().equals("soapNamespace")) {
				group.setSoapNamespace(elem.getText());
			} else if (elem.getLocalName().equals("recordTypeNamespace")) {
				group.setRecordTypeNamespace(elem.getText());
			} else if (elem.getLocalName().equals("securityNamespace")) {
				group.setSecurityNamespace(elem.getText());
			}
			
			if (elem.getLocalName().equals("property")) {//$NON-NLS-1$
				t = elem.getText();
				if ((t != null) && (t.length() > 0)) 
					p = new String(t);
			}
			if (elem.getLocalName().equals("value")) {//$NON-NLS-1$
				t = elem.getText();
				if ((t != null) && (t.length() > 0)) 
					group.getProperties().setProperty(p,t);
			}
		}
		return group;
	}
}
