/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypeList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRegistrationServiceMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IServiceDescription;

/**
 * Root object of a registrationServiceMetadata
 * 
 * @author Bill Muldoon
 */
public class RegistrationServiceMetadata implements IRegistrationServiceMetadata 
{
	private IServiceDescription serviceDescription = null;
	private IRecordTypeList recordTypeList = null;

	/**
	 * set the serviceDescription of the queryServiceMetadata
	 * 
	 * @param serviceDescription
	 */
	public void setServiceDescription(IServiceDescription serviceDescription){
		this.serviceDescription = serviceDescription;
	}
	
	/**
	 * Retrieve a serviceDescription
	 * 
	 * @return IServiceDescription
	 */
	public IServiceDescription getServiceDescription(){
		return serviceDescription;
	}

	
	/**
	 * set the recordTypeList in the queryServiceMetaData
	 * 
	 * @param recordTypeList
	 */
	public void setRecordTypeList(IRecordTypeList recordTypeList){
		this.recordTypeList = recordTypeList;
	}
		
	/**
	 * Retrieve a recordTypeList
	 * 
	 * @return IRecordTypeList
	 */
	public IRecordTypeList getRecordTypeList(){
		return recordTypeList;
	}

	
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write( ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ServiceMetadataConstants.REGISTRATIONSERVICEMETADATA_ELEMENT +
				      " xmlns=\""+ServiceMetadataConstants.SERVICEMETADATA_NAMESPACE+ICMDBfServicesConstants.DOUBLE_QUOTE + 
				      ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		if ( serviceDescription != null ){
			serviceDescription.toXML( writer, indent + 1 );
		}
		
		if ( recordTypeList != null ){
			recordTypeList.toXML( writer, indent + 1 );
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.REGISTRATIONSERVICEMETADATA_ELEMENT)+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RegistrationServiceMetadata other = (RegistrationServiceMetadata) obj;
		if (serviceDescription == null) {
			if (other.serviceDescription != null)
				return false;
		} else if (!serviceDescription.equals(other.serviceDescription))
			return false;
		if (recordTypeList == null) {
			if (other.recordTypeList != null)
				return false;
		} else if (!recordTypeList.equals(other.recordTypeList))
			return false;
		return true;
	}
	
}
