/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.dr.internal.web.ui.WebViewerActivator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.cosmos.dr.web.ui.viewer"; //$NON-NLS-1$
	
	public static final String WEBAPP_NAME = "COSMOSUI"; //$NON-NLS-1$
	public static final String WEBAPP_CONTEXT = "viewertest"; //$NON-NLS-1$


	// The shared instance
	private static Activator plugin;
	
    protected String portPreference;
    protected String dojoPathPreference;
    protected String hostPreference;
    protected String dojoBasePathPreference;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		WebViewerActivator.getDefault().setLauncher(new WebLauncher());
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		WebViewer.stop(WEBAPP_CONTEXT);
		stopWebService();
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	public void stopWebService() throws Exception{
		WebViewer.stop(WEBAPP_CONTEXT);	
	}	
	
	public void startWebService() throws Exception{
		WebViewer.start(WEBAPP_CONTEXT);	
	}	
	
	
    public static IStatus createErrorStatus( final String msg )
    {
        return createErrorStatus( msg, null );
    }

    public static IStatus createErrorStatus( final String msg,
                                             final Exception e )
    {
        return new Status( IStatus.ERROR, PLUGIN_ID, 0, msg, e );
    }	
    
	public String getPortPreference() {
		return portPreference;
	}

	public void setPortPreference(String portPreference) {
		this.portPreference = portPreference;
	}

	public String getDojoPathPreference() {
		return dojoPathPreference;
	}

	public void setDojoPathPreference(String dojoPathPreference) {
		this.dojoPathPreference = dojoPathPreference;
	}

	public String getHostPreference() {
		return hostPreference;
	}

	public void setHostPreference(String hostPreference) {
		this.hostPreference = hostPreference;
	}
	
	public String getDojoBasePathPreference() {
		return dojoBasePathPreference;
	}

	public void setDojoBasePathPreference(String dojoBasePathPreference) {
		this.dojoBasePathPreference = dojoBasePathPreference;
	}

	public void updateActivatorPreference(){
		setDojoBasePathPreference(WebViewerActivator.getDefault().getDojoBasePathPreference());
		setDojoPathPreference(WebViewerActivator.getDefault().getDojoPathPreference());
		setHostPreference(WebViewerActivator.getDefault().getHostPreference());
		setPortPreference(WebViewerActivator.getDefault().getPortPreference());
	}
	
	
}
