/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ReportElement.java,v 1.2 2008/08/20 19:42:13 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportElement implements Serializable {
	private static final long serialVersionUID = 7713301965312164326L;
	protected Map<String, String> metadata;
	protected Element elem;
	protected Element localId;
	protected Element filename;
	
	public ReportElement(Element elem) {
		super();
		metadata = new HashMap<String,String>();
		this.elem = elem;
		NodeList list = elem.getElementsByTagName("visualizationId");
		if (list.getLength() > 0){
			Element visualizationId = (Element)list.item(0);
			list = visualizationId.getElementsByTagName("localId");
			if (list.getLength() > 0){
				localId = (Element)list.item(0);
			}
			list = visualizationId.getElementsByTagName("filename");
			if (list.getLength() > 0){
				filename = (Element)list.item(0);
			}
		}
		list = elem.getElementsByTagName("visualizationDescription");
		if (list.getLength() > 0){
			Element visualizationDescription = (Element)list.item(0);
			list = visualizationDescription.getChildNodes();
			for (int x = 0; x < list.getLength(); x++){
				if (list.item(x).getNodeType() == Node.ELEMENT_NODE){
					Element property = (Element)list.item(x);
					metadata.put(property.getTagName(), property.getTextContent());
				}
			}
		}
		
		
	}

	public String getMetaData(String key) {
		return metadata.get(key);
	}

	public void putMetaData(String key, String value) {
		this.metadata.put(key, value);
	}

	public String getId() {
		return localId.getTextContent();
	}


	public String getFilename() {
		return filename.getTextContent();
	}

}
