/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * CA - Initial API and implementation
 *
 **********************************************************************/

package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;

public class ServiceMetaDataOutputter extends AbstractOutputter {
	public static final String USERNAME="username"; //$NON-NLS-1$
	public static final String PASSWORD="password"; //$NON-NLS-1$
	public static final String SOAPVERSION="soapversion"; //$NON-NLS-1$
		
	public void render(PrintWriter output, IParameters input) throws Exception {		
		String mdrEPR = input.getParameter("mdr"); //$NON-NLS-1$
		String username = input.getParameter(USERNAME);
		String password = input.getParameter(PASSWORD);
		String soapversion = input.getParameter(SOAPVERSION);
				
		QueryServiceClient queryService =   new QueryServiceClient(mdrEPR);
		Element result = queryService.getQueryServiceMetadata();
		if (username != null)
			queryService.setUsername(username);
		if (password != null)
			queryService.setPassword(password);
		if (soapversion != null)
			queryService.setSoapVersion(Integer.parseInt(soapversion));
		
		if (result==null) 
			output.print(Messages.getString("ServiceMetaDataOutputter.1")); //$NON-NLS-1$
		else {
			output.print(XMLUtil.xmlToString(result));
		}
			
	}
	
}

