/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.common");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Layouts");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Navigator");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.WidgetContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.DataView");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.Report");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryBuilder");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryRelItemTree");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseViewer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.GraphResponseTreeViewer");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.widget.RecordDetailsDialog");
dojo.require("dijit.TitlePane");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "utility");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget");

dojo.declare(
		'org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer',
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
			// summary: This widget provides an iframe container to embed html content
			// description: This web component is used to embed html content from external systems. 
			//              For example, reports generated from a reporting system can be embedded 
			//              in this component. This allows an application to compose pages that are 
			//              made up of content from various external sources.
			//templatePath: String
			//   url path to the widget html template that describes this widget 
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/HTMLContainer.html"),
			// width: String
			//   specifies the width of the container
			width : "100%",
			// height: String
			//   specifies the height of the container
			height : "400",
			//content_provider: String
			//    url that contains the content that will be embedded in the iframe
			content_provider: "report.jsp",
			name:"",
			namespace:"",
			xmlvalue:"",			
			//frameNode: Element
			//  element node that represents the iframe
			frameNode: null,
			formNode: null,
			//contentQuery: org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery
			//  a query object that provides the url used to update the content of the iframe 
			contentQuery:null,
			datasourceid:null,
			postCreate: function(){
				//summary: inherited diji._Widget method
				org.eclipse.cosmos.provisional.dr.ps.components.widget.HTMLContainer.superclass.postCreate.apply(this, arguments);
				this.resize();
				if (this.postInputs){
			    	var inputObject = this.UIContext.createObject(this.postInputs);
			    	if (inputObject){
						var inputs = inputObject.getInputs(this.contextMap);
						for(var key in inputs) {
							var value = inputs[key];
							this.addHiddenInput(key, value);
						}				
						this.formNode.submit();
			    	}
			    	else{
						this.refreshContent(this.contextMap);
			    	}
				}
		    	else{
					this.refreshContent(this.contextMap);
		    	}
			},		
			addHiddenInput: function(name, value){
				//summary: postMixinProperties method for this widget
				//description: initializes the menu for the tree
				var cell = document.createElement("input");
				cell.setAttribute("type", "hidden");
				cell.setAttribute("name", name);
				cell.setAttribute("value", value);
				this.formNode.appendChild(cell);
			},			
			create: function(params, srcNodeRef) {
				//summary: This method will refresh the contents of the iframe based on the information stored in the message parameter.
				//description:  A XMLHttpRequest is made on the information stored in the queryObject.  The message parameter properties
				//              are passed to the query object.  The response returned from the XMLHttpRequest contains the url that is used
				//              as the content of the iframe
				var self = this;
				var args = arguments;
				//make REST call to get content data
				self.inherited(arguments);
		    },
		    refreshContent:function(/*Object*/message) {
				//summary: This method will refresh the contents of the iframe based on the information stored in the message parameter.
				//description:  A XMLHttpRequest is made on the information stored in the queryObject.  The message parameter properties
				//              are passed to the query object.  The response returned from the XMLHttpRequest contains the url that is used
				//              as the content of the iframe
				var self = this;
				//make REST call to get content data
				if ((typeof(this.contentQuery) != 'undefined') && (this.contentQuery != null)){
			    	var queryObject = this.UIContext.createObject(this.contentQuery);
			    	message.datasourceid = self.datasourceid;
					if (!(this.UIContext.submitQuery({queryObject:queryObject, item:message, onItem:function(response){
							self.changeit(response);						 												
							}, queryProp:"query"}))){					
					//reset page
						this.changeit(this.blankPath);
					}
				}
				else if (message.contentNode){
					this.changeit(message.contentNode);
				}
		    },
			changeit:function(/*String*/url){
		    	//summary: This method will change the content of the iframe based on the url passed in
	  			this.frameNode.src=url;
			},
			resize:function(){
				//summary: updates the content of the iframe based on a resize change
				if(!this.domNode.parentNode){
					return;
				}
				var h = dojo._getContentBox(this.domNode.parentNode).h;
				this.frameNode.style.height = (h-10) + 'px';

			},
			// blankPath:String
			//    Url path to a blank html page.  This page is used if no url is specified
			blankPath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/blank.html")
		}
); 

dojo.declare(
		'org.eclipse.cosmos.provisional.dr.ps.components.widget.ContentContainer',
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/ContentContainer.html"),
			//widgetsInTemplate:boolean
			// determines if the html template contains dojo widgets
			widgetsInTemplate: true,			
			contentValue: "",
			title: "",
			create: function(params, srcNodeRef) {
				if ((params.contextMap) && (params.contextMap.query))
					this.contentValue = params.contextMap.query[0];
				if (this.contentValue)
				{
					this.contentValue = params.UIContext.xmlFormatter.format(this.contentValue);
					
				}				
				this.inherited(arguments);
			}			
		}
); 

dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.Dialog",
		[dijit._Widget, dijit._Templated, dijit._Container], 
		{
		 	//labelQuery:String
		 	//The description label
			labelQuery:"",
		    //nameLabelQuery:String
		    //  The name label of the dialog box
			nameLabelQuery:"",
			//title:String
			//The title label
			title:"",	
			name:"",
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
			//widgetsInTemplate:boolean
			// determines if the html template contains dojo widgets
			widgetsInTemplate: true,
			create: function(params, srcNodeRef) {
			//summary: inherited class from dijit._Widget
				//for some reason I need to destroy widget explicitly
	   			if (dijit.byId(this.widgetId) != null)
	   				dijit.byId(this.widgetId).destroy();
	            var today = new Date();
				this.name=this._message.CMDBFQUERY+" "+today;
				this.item={title:this.name,object:today};
				this.cancelLbl=this._message.CANCEL;
				this.submitLbl=this._message.SUBMIT;
				this.nameLabelQuery=this._message.NAME;
				this.okLbl=this._message.OK;
				org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.create.apply(this, arguments);
			},			
			show: function(){
			//summary: displays the dialog box on the screen
				this.dialogBox.show();
			},
			onCancel: function(){
			//summary: this method is executed when the user clicks on the 'Cancel' button
				this.dialogBox.onCancel();
				this.destroy();
			},
			quit: function(){
			//summary: this method is executed when the user clicks on the 'Quit' button
				this.dialogBox.onCancel();
				this.destroy();
			},
			submitQuery: function(){
			},
			destroy:function(){
			//summary: destroys this widget
				if (this.dialogBox){
					this.dialogBox.onCancel();
				}
				this.inherited(arguments);
			},
			addItem: function(item){
			},
			onKeyEvt: function(/*Event*/ evt){
				// summary: keep keyboard focus in dialog; close dialog on escape key
				if(evt.keyCode == dojo.keys.ENTER){
					this.submitQuery();
					this.destroy();
				}
			},		
			postCreate: function(){
			//summary: inherited class from dijit._Widget
				this.inherited(arguments);
				this.dialogBox = dijit.byId(this.widgetId);
				dojo.connect(this.dialogBox, "_onKey", this, "onKeyEvt");			
				dojo.connect(this.dialogBox.closeButtonNode,"onclick", this, "destroy"); 			
			}
			
		}
	);

