/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class NetServlet
extends HttpServlet {
    private static final int MAX_CONNECT_TRYS = 20;
    private static final String SERVLET_PROP_MESSAGES = "org.apache.derby.loc.drda.servlet";
    private static final String SERVLET_ADDRESS = "derbynet";
    private String formHeader = null;
    private String host = "localhost";
    private int portNumber = 1527;
    private String tracingDirectory;
    private boolean logStatus = false;
    private boolean traceStatus = false;
    private String[] knownLang = new String[]{"cs", "en", "es", "de_DE", "fr", "hu", "it", "ja_JP", "ko_KR", "pl", "pt_BR", "ru", "zh_CN", "zh_TW"};
    private String locale;
    private static final int NOT_GIVEN = -2;
    private static final int INVALID = -3;
    private NetworkServerControl server;
    private PrintWriter out;
    private Runnable service;

    public void init(ServletConfig config) throws ServletException {
        boolean start;
        String hostName;
        int p;
        LocalizedResource langUtil = new LocalizedResource(null, null, SERVLET_PROP_MESSAGES);
        String port = config.getInitParameter("portNumber");
        if (port != null && (p = Integer.valueOf(port).intValue()) > 0) {
            this.portNumber = p;
        }
        if ((hostName = config.getInitParameter("host")) != null) {
            this.host = hostName;
        }
        this.tracingDirectory = config.getInitParameter("tracingDirectory");
        if (this.tracingDirectory == null) {
            this.tracingDirectory = "";
        }
        String startup = config.getInitParameter("startNetworkServerOnInit");
        try {
            if (this.server == null) {
                this.server = new NetworkServerControl(InetAddress.getByName(this.host), this.portNumber);
                if (!this.tracingDirectory.trim().equals("")) {
                    this.server.setTraceDirectory(this.tracingDirectory);
                }
            }
            if (NetServlet.isServerStarted(this.server, 1)) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (startup != null && (start = Boolean.valueOf(startup).booleanValue())) {
            this.runServer(langUtil, null, null);
            return;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LocalizedResource langUtil = this.getCurrentAppUI(request);
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache,no-store");
        this.formHeader = "<form enctype='multipart/form-data; charset=UTF-8' action='" + request.getRequestURI() + " '>";
        this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF8"), true);
        String logOnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_LogOn"));
        String logOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_LogOff"));
        String traceOnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOn"));
        String traceOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOff"));
        String startMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Start"));
        String stopMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Stop"));
        String traceSessionMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceSessButton"));
        String traceOnOffMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceOnOff"));
        String returnMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Return"));
        String traceDirMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_TraceDir"));
        String contMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_Continue"));
        String setParamMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_SetParam"));
        String setParamMessage2 = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_SetParam2"));
        String netParamMessage = this.escapeSingleQuotes(langUtil.getTextMessage("SRV_NetParam"));
        this.printBanner(langUtil);
        if (this.server == null) {
            try {
                this.server = new NetworkServerControl();
            }
            catch (Exception e) {
                this.printErrorForm(langUtil, request, e, returnMessage);
                return;
            }
        }
        this.server.setClientLocale(this.locale);
        String form = this.getForm(request);
        String doAction = this.getDoAction(request);
        if (doAction != null) {
            form = doAction.equals(traceOnOffMessage) ? traceSessionMessage : doAction;
        }
        boolean serverStatus = this.getServerStatus();
        if (form == null) {
            form = serverStatus ? startMessage : stopMessage;
        } else if (form.equals(startMessage)) {
            if (!serverStatus) {
                this.runServer(langUtil, request, returnMessage);
            }
        } else if (form.equals(stopMessage)) {
            if (serverStatus) {
                this.shutdownServer(langUtil, request, returnMessage);
            }
            this.setDefaults();
        } else if (form.equals(returnMessage) || form.equals(returnMessage)) {
            form = serverStatus ? startMessage : stopMessage;
        }
        this.out.println(this.formHeader);
        form = this.escapeSingleQuotes(form);
        doAction = this.escapeSingleQuotes(doAction);
        if (form.equals(startMessage)) {
            String logButton = this.getLogging(request);
            String traceButton = this.getTrace(request);
            if (logButton != null && logButton.equals(logOnMessage) && this.logging(langUtil, true, request, returnMessage)) {
                this.logStatus = true;
            }
            if (logButton != null && logButton.equals(logOffMessage) && this.logging(langUtil, false, request, returnMessage)) {
                this.logStatus = false;
            }
            if (traceButton != null && traceButton.equals(traceOnMessage) && this.traceAll(langUtil, true, request, returnMessage)) {
                this.traceStatus = true;
            }
            if (traceButton != null && traceButton.equals(traceOffMessage) && this.traceAll(langUtil, false, request, returnMessage)) {
                this.traceStatus = false;
            }
            this.displayCurrentStatus(request, langUtil, returnMessage);
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_StopButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + stopMessage + "'>");
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_LogButton2") + "</h4>");
            if (this.logStatus) {
                this.out.println("<INPUT type=submit name=logform value='" + logOffMessage + "'>");
            } else {
                this.out.println("<INPUT type=submit name=logform value='" + logOnMessage + "'>");
            }
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_TraceButton2") + "</h4>");
            if (this.traceStatus) {
                this.out.println("<INPUT type=submit name=traceform value='" + traceOffMessage + "'>");
            } else {
                this.out.println("<INPUT type=submit name=traceform value='" + traceOnMessage + "'>");
            }
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_TraceSession") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + traceSessionMessage + "'>");
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_TraceDirButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + traceDirMessage + "'>");
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_ThreadButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + netParamMessage + "'>");
        } else if (form.equals(stopMessage)) {
            this.printAsContentHeader(langUtil.getTextMessage("SRV_NotStarted"));
            String logButton = this.getLogging(request);
            String traceButton = this.getTrace(request);
            if (logButton != null && logButton.equals(logOnMessage)) {
                this.logStatus = true;
            }
            if (logButton != null && logButton.equals(logOffMessage)) {
                this.logStatus = false;
            }
            if (traceButton != null && traceButton.equals(traceOnMessage)) {
                this.traceStatus = true;
            }
            if (traceButton != null && traceButton.equals(traceOffMessage)) {
                this.traceStatus = false;
            }
            if (this.logStatus) {
                this.out.println("<h4>" + langUtil.getTextMessage("SRV_LogOffButton") + "</h4>");
                this.out.println("<INPUT type=submit name=logform value='" + logOffMessage + "'>");
            } else {
                this.out.println("<h4>" + langUtil.getTextMessage("SRV_LogOnButton") + "</h4>");
                this.out.println("<INPUT type=submit name=logform value='" + logOnMessage + "'>");
            }
            if (this.traceStatus) {
                this.out.println("<h4>" + langUtil.getTextMessage("SRV_TraceOffButton") + "</h4>");
                this.out.println("<INPUT type=submit name=traceform value='" + traceOffMessage + "'>");
            } else {
                this.out.println("<h4>" + langUtil.getTextMessage("SRV_TraceOnButton") + "</h4>");
                this.out.println("<INPUT type=submit name=traceform value='" + traceOnMessage + "'>");
            }
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_StartButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + startMessage + "'>");
        } else if (form.equals(traceSessionMessage)) {
            if (doAction != null && doAction.equals(traceOnOffMessage)) {
                String sessionid = request.getParameter("sessionid");
                int session = 0;
                try {
                    session = new Integer(sessionid);
                }
                catch (Exception e) {
                    this.printErrorForm(langUtil, request, langUtil.getTextMessage("SRV_InvalidVal", sessionid, langUtil.getTextMessage("SRV_SessionID")), returnMessage);
                    return;
                }
                Properties p = null;
                try {
                    p = this.server.getCurrentProperties();
                }
                catch (Exception e) {
                    this.printErrorForm(langUtil, request, e, returnMessage);
                    return;
                }
                boolean val = p.getProperty("derby.drda.trace" + sessionid) == null;
                if (this.traceSession(langUtil, val, session, request, returnMessage)) {
                    if (val) {
                        this.out.println("<h4>" + langUtil.getTextMessage("SRV_StatusTraceNoOn", sessionid) + "</h4>");
                    } else {
                        this.out.println("<h4>" + langUtil.getTextMessage("SRV_StatusTraceNoOff", sessionid) + "</h4>");
                    }
                } else {
                    return;
                }
            }
            this.printAsContentHeader(langUtil.getTextMessage("SRV_TraceSessButton"));
            this.out.println("<h4>" + this.getHtmlLabelledMessageInstance(langUtil, "SRV_SessionID", "sessionId") + "</h4>");
            this.out.println("<INPUT type=text name=sessionid size=10 maxlength=10 id='sessionId' value=''>");
            this.out.println("<h4> </h4>");
            this.out.println("<INPUT type=submit name=doaction value='" + traceOnOffMessage + "'>");
            this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        } else if (form.equals(traceDirMessage)) {
            boolean set = false;
            String traceDirectory = null;
            this.printAsContentHeader(traceDirMessage);
            if (doAction != null && doAction.equals(traceDirMessage)) {
                traceDirectory = this.getParam(request, "tracedirectory");
                if (this.traceDirectory(langUtil, traceDirectory, request, returnMessage)) {
                    set = true;
                } else {
                    return;
                }
            }
            if (set) {
                this.out.println("<h2>" + langUtil.getTextMessage("SRV_TraceDirDone", traceDirectory) + "</h2>");
                this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
            } else {
                this.out.println("<h4>" + this.getHtmlLabelledMessageInstance(langUtil, "SRV_TraceDir", "tracedir") + "</h4>");
                this.out.println("<INPUT type=text name=tracedirectory size=60 maxlength=256 id='tracedir' value='" + this.tracingDirectory + "'>");
                this.out.println("<h4> </h4>");
                this.out.println("<INPUT type=submit name=doaction value='" + traceDirMessage + "'>");
                this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
            }
        } else if (form.equals(netParamMessage)) {
            int maxThreads = 0;
            int timeSlice = 0;
            String maxName = langUtil.getTextMessage("SRV_NewMaxThreads");
            String sliceName = langUtil.getTextMessage("SRV_NewTimeSlice");
            try {
                Properties p = this.server.getCurrentProperties();
                String val = p.getProperty("derby.drda.maxThreads");
                maxThreads = new Integer(val);
                val = p.getProperty("derby.drda.timeSlice");
                timeSlice = new Integer(val);
            }
            catch (Exception e) {
                this.printErrorForm(langUtil, request, e, returnMessage);
                return;
            }
            if (doAction != null && doAction.equals(netParamMessage)) {
                int newTimeSlice;
                int newMaxThreads = this.getIntParameter(request, "newmaxthreads", "SRV_NewMaxThreads", langUtil, returnMessage);
                int n = newTimeSlice = newMaxThreads == -3 ? -2 : this.getIntParameter(request, "newtimeslice", "SRV_NewTimeSlice", langUtil, returnMessage);
                if (newMaxThreads == -3 || newTimeSlice == -3) {
                    return;
                }
                if (newMaxThreads != -2 || newTimeSlice != -2) {
                    if (newMaxThreads != -2) {
                        maxThreads = newMaxThreads;
                    }
                    if (newTimeSlice != -2) {
                        timeSlice = newTimeSlice;
                    }
                    if (!this.setNetParam(langUtil, maxThreads, timeSlice, request, returnMessage)) {
                        return;
                    }
                }
            }
            this.out.println(this.formHeader);
            this.printAsContentHeader(netParamMessage);
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_MaxThreads", new Integer(maxThreads).toString()) + "</h4>");
            this.out.println("<h4>" + langUtil.getTextMessage("SRV_TimeSlice", new Integer(timeSlice).toString()) + "</h4>");
            this.out.println("<h4> </h4>");
            this.out.println("<h4> <label for='newmaxthreads'>" + maxName + "</label> </h4>");
            this.out.println("<INPUT type=text name=newmaxthreads size=10 maxlength=10 id='newmaxthreads' value=''>");
            this.out.println("<h4> <label for='newslice'>" + sliceName + "</label> </h4>");
            this.out.println("<INPUT type=text name=newtimeslice size=10 maxlength=10 id='newslice' value=''>");
            this.out.println("<h4> </h4>");
            this.out.println("<INPUT type=submit name=doaction value='" + netParamMessage + "'>");
            this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        } else {
            System.out.println("Internal Error: Unknown form, " + form);
            this.out.println("Internal Error: Unknown form, " + form);
        }
        this.out.println("</html>");
        this.out.println("</body>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getForm(HttpServletRequest request) throws IOException {
        return this.getParam(request, "form");
    }

    private String getDoAction(HttpServletRequest request) throws IOException {
        return this.getParam(request, "doaction");
    }

    private String getLogging(HttpServletRequest request) throws IOException {
        return this.getParam(request, "logform");
    }

    private String getTrace(HttpServletRequest request) throws IOException {
        return this.getParam(request, "traceform");
    }

    private String getParam(HttpServletRequest request, String paramName) throws IOException {
        String newValue = null;
        String value = request.getParameter(paramName);
        if (value == null) {
            return value;
        }
        newValue = new String(value.getBytes("ISO-8859-1"), "UTF8");
        return newValue;
    }

    private void runServer(LocalizedResource localUtil, HttpServletRequest request, String returnMessage) throws ServletException {
        this.service = new Runnable(){

            public void run() {
                try {
                    NetworkServerControl runserver = new NetworkServerControl(InetAddress.getByName(NetServlet.this.host), NetServlet.this.portNumber);
                    runserver.start(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
        Thread servThread = null;
        try {
            servThread = (Thread)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Thread(NetServlet.this.service);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        servThread.start();
        try {
            boolean connectWorked = false;
            int t = 0;
            do {
                ++t;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw new ServletException(localUtil.getTextMessage("SRV_Interupt"));
                }
                try {
                    if (!NetServlet.isServerStarted(this.server, 1)) continue;
                    connectWorked = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while (!connectWorked && t < 20);
            if (t >= 20) {
                throw new Exception(localUtil.getTextMessage("SRV_MaxTrys", new Integer(20).toString()));
            }
            if (this.logStatus) {
                this.server.logConnections(true);
            }
            if (this.traceStatus) {
                this.server.trace(true);
            }
        }
        catch (Exception e) {
            if (this.out != null) {
                this.printErrorForm(localUtil, request, e, returnMessage);
            }
            throw new ServletException(e.getMessage());
        }
    }

    private void printErrorForm(LocalizedResource localUtil, HttpServletRequest request, Exception e, String returnMessage) {
        this.printAsContentHeader(localUtil.getTextMessage("SRV_NetworkServerError"));
        this.out.println("<h4>" + localUtil.getTextMessage("SRV_Message", e.getMessage()) + "</h4>");
        this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        this.out.println("</html>");
        this.out.println("</body>");
    }

    private void printErrorForm(LocalizedResource localUtil, HttpServletRequest request, String msg, String returnMessage) {
        this.printAsContentHeader(localUtil.getTextMessage("SRV_NetworkServerError"));
        this.out.println("<h4>" + localUtil.getTextMessage("SRV_Message", msg) + "</h4>");
        this.out.println("<INPUT type=submit name=form value='" + returnMessage + "'>");
        this.out.println("</html>");
        this.out.println("</body>");
    }

    private void displayCurrentStatus(HttpServletRequest request, LocalizedResource localUtil, String returnMessage) {
        try {
            this.printAsContentHeader(localUtil.getTextMessage("SRV_Started"));
            Properties p = this.server.getCurrentProperties();
            String val = p.getProperty("derby.drda.logConnections");
            this.logStatus = val.equals("true");
            if (this.logStatus) {
                this.out.println("<h4>" + localUtil.getTextMessage("SRV_StatusLogOn") + "</h4>");
            } else {
                this.out.println("<h4>" + localUtil.getTextMessage("SRV_StatusLogOff") + "</h4>");
            }
            val = p.getProperty("derby.drda.traceAll");
            this.traceStatus = val.equals("true");
            if (this.traceStatus) {
                this.out.println("<h4>" + localUtil.getTextMessage("SRV_StatusTraceOn") + "</h4>");
            } else {
                this.out.println("<h4>" + localUtil.getTextMessage("SRV_StatusTraceOff") + "</h4>");
            }
            val = p.getProperty("derby.drda.portNumber");
            this.out.println("<h4>" + localUtil.getTextMessage("SRV_PortNumber", val) + "</h4>");
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
    }

    private boolean getServerStatus() {
        try {
            if (NetServlet.isServerStarted(this.server, 1)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean shutdownServer(LocalizedResource localUtil, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        try {
            this.server.shutdown();
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private boolean logging(LocalizedResource localUtil, boolean val, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        try {
            this.server.logConnections(val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private boolean traceAll(LocalizedResource localUtil, boolean val, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        try {
            this.server.trace(val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private boolean traceSession(LocalizedResource localUtil, boolean val, int session, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        try {
            this.server.trace(session, val);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private boolean traceDirectory(LocalizedResource localUtil, String traceDirectory, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        if (traceDirectory == null || traceDirectory.equals("")) {
            this.printErrorForm(localUtil, request, localUtil.getTextMessage("SRV_MissingParam", localUtil.getTextMessage("SRV_TraceDir")), returnMessage);
            return retval;
        }
        try {
            this.tracingDirectory = traceDirectory;
            this.server.setTraceDirectory(traceDirectory);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private boolean setNetParam(LocalizedResource localUtil, int max, int slice, HttpServletRequest request, String returnMessage) {
        boolean retval = false;
        try {
            this.server.setMaxThreads(max);
            this.server.setTimeSlice(slice);
            retval = true;
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, e, returnMessage);
        }
        return retval;
    }

    private void setDefaults() {
        this.logStatus = false;
        this.traceStatus = false;
    }

    private int getIntParameter(HttpServletRequest request, String name, String fieldKey, LocalizedResource localUtil, String returnMessage) {
        int retval;
        String val = request.getParameter(name);
        if (val == null || val.equals("")) {
            return -2;
        }
        try {
            retval = new Integer(val);
        }
        catch (Exception e) {
            this.printErrorForm(localUtil, request, localUtil.getTextMessage("SRV_InvalidVal", val, localUtil.getTextMessage(fieldKey)), returnMessage);
            return -3;
        }
        if (retval < 0) {
            this.printErrorForm(localUtil, request, localUtil.getTextMessage("SRV_InvalidVal", val, localUtil.getTextMessage(fieldKey)), returnMessage);
            return -3;
        }
        return retval;
    }

    private void printBanner(LocalizedResource localUtil) {
        this.out.println("<a href=\"#navskip\">[ " + localUtil.getTextMessage("SRV_SkipToContent") + " ]</a>");
        this.out.println("  -  <a href=\"derbynet\">[ " + localUtil.getTextMessage("SRV_BackToMain") + " ]</a>");
        this.out.println("<html>");
        this.out.println("<title>" + localUtil.getTextMessage("SRV_Banner") + "</title>");
        this.out.println("<body>");
        this.out.println("<hr>");
        this.out.println("<h1>" + localUtil.getTextMessage("SRV_Banner") + "</h1>");
        this.out.println("<hr>");
    }

    private LocalizedResource getCurrentAppUI(HttpServletRequest request) {
        String acceptLanguage = request.getHeader("Accept-Language");
        LocalizedResource localUtil = new LocalizedResource(null, null, SERVLET_PROP_MESSAGES);
        this.locale = null;
        if (acceptLanguage == null) {
            return localUtil;
        }
        StringTokenizer tokenizer = new StringTokenizer(acceptLanguage, ",");
        while (tokenizer.hasMoreTokens()) {
            String lang = tokenizer.nextToken();
            int langindex = this.translationAvailable(lang = this.getLocStringFromLanguage(lang));
            if (langindex == -1) continue;
            localUtil.init(null, lang, SERVLET_PROP_MESSAGES);
            this.locale = lang;
            return localUtil;
        }
        return localUtil;
    }

    private String getLocStringFromLanguage(String lang) {
        int semi = lang.indexOf(59);
        if (semi != -1) {
            lang = lang.substring(0, semi);
        }
        lang = this.fixLanguageCode(lang.trim());
        return lang;
    }

    private int translationAvailable(String lang) {
        for (int i = 0; i < this.knownLang.length; ++i) {
            if (!this.knownLang[i].equals(lang)) continue;
            return i;
        }
        return -1;
    }

    private String fixLanguageCode(String lang) {
        int index = lang.indexOf(45);
        if (index != -1) {
            return this.fixLanguageCode(lang, index);
        }
        index = lang.indexOf(95);
        if (index != -1) {
            return this.fixLanguageCode(lang, index);
        }
        return lang;
    }

    private String fixLanguageCode(String lang, int index) {
        return lang.substring(0, index) + "_" + lang.substring(index + 1).toUpperCase(Locale.ENGLISH);
    }

    public String getHtmlLabelledMessageInstance(LocalizedResource localUtil, String key, String id) {
        if (id == null) {
            id = "";
        }
        return "<label for='" + id + "'>" + localUtil.getTextMessage(key) + "</label>";
    }

    private void printAsContentHeader(String str) {
        this.out.println("<a name=\"navskip\"></a><h2>" + str + "</h2>");
    }

    private String escapeSingleQuotes(String str) {
        if (str == null || str.indexOf("'") < 0) {
            return str;
        }
        char[] cA = str.toCharArray();
        char[] result = new char[4 * cA.length];
        int j = 0;
        for (int i = 0; i < cA.length; ++i) {
            if (cA[i] == '\'') {
                result[j++] = 38;
                result[j++] = 35;
                result[j++] = 51;
                result[j++] = 57;
                continue;
            }
            result[j++] = cA[i];
        }
        return new String(result, 0, j);
    }

    private static boolean isServerStarted(NetworkServerControl server, int ntries) {
        for (int i = 1; i <= ntries; ++i) {
            try {
                Thread.sleep(500L);
                server.ping();
                return true;
            }
            catch (Exception e) {
                if (i != ntries) continue;
                return false;
            }
        }
        return false;
    }
}

