/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class CreateRoleNode
extends DDLStatementNode {
    private String name;

    public void init(Object roleName) throws StandardException {
        this.initAndCheck(null);
        this.name = (String)roleName;
    }

    public String toString() {
        return super.toString() + "roleName: " + "\n" + this.name + "\n";
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.isPrivilegeCollectionRequired()) {
            cc.addRequiredRolePriv(this.name, 19);
        }
    }

    public String statementToString() {
        return "CREATE ROLE";
    }

    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateRoleConstantAction(this.name);
    }
}

