/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class DropViewNode
extends DDLStatementNode {
    public void init(Object dropObjectName) throws StandardException {
        this.initAndCheck(dropObjectName);
    }

    public String statementToString() {
        return "DROP VIEW";
    }

    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        CompilerContext cc = this.getCompilerContext();
        TableDescriptor td = dd.getTableDescriptor(this.getRelativeName(), this.getSchemaDescriptor(), this.getLanguageConnectionContext().getTransactionCompile());
        if (td != null) {
            cc.createDependency(td);
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropViewConstantAction(this.getFullName(), this.getRelativeName(), this.getSchemaDescriptor());
    }
}

