/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class OrNode
extends BinaryLogicalOperatorNode {
    private boolean firstOr;

    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "or");
        this.shortCircuitValue = true;
    }

    void setFirstOr() {
        this.firstOr = true;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        this.postBindFixup();
        return this;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.firstOr) {
            BinaryRelationalOperatorNode bron;
            boolean convert = true;
            ColumnReference cr = null;
            int columnNumber = -1;
            int tableNumber = -1;
            ValueNode vn = this;
            while (vn instanceof OrNode) {
                OrNode on = vn;
                ValueNode left = on.getLeftOperand();
                if (!left.isRelationalOperator()) {
                    bron = null;
                    if (left instanceof BinaryRelationalOperatorNode && !(bron = (BinaryRelationalOperatorNode)left).isInListProbeNode()) {
                        SanityManager.THROWASSERT("isRelationalOperator() unexpectedly returned false for a BinaryRelationalOperatorNode.");
                    }
                    if (!(convert = left instanceof BinaryRelationalOperatorNode)) break;
                }
                if (((RelationalOperator)((Object)left)).getOperator() != 1) {
                    convert = false;
                    break;
                }
                bron = (BinaryRelationalOperatorNode)left;
                if (bron.getLeftOperand() instanceof ColumnReference) {
                    cr = (ColumnReference)bron.getLeftOperand();
                    if (tableNumber == -1) {
                        tableNumber = cr.getTableNumber();
                        columnNumber = cr.getColumnNumber();
                    } else if (tableNumber != cr.getTableNumber() || columnNumber != cr.getColumnNumber()) {
                        convert = false;
                        break;
                    }
                } else if (bron.getRightOperand() instanceof ColumnReference) {
                    cr = (ColumnReference)bron.getRightOperand();
                    if (tableNumber == -1) {
                        tableNumber = cr.getTableNumber();
                        columnNumber = cr.getColumnNumber();
                    } else if (tableNumber != cr.getTableNumber() || columnNumber != cr.getColumnNumber()) {
                        convert = false;
                        break;
                    }
                } else {
                    convert = false;
                    break;
                }
                vn = vn.getRightOperand();
            }
            if (convert) {
                ValueNodeList vnl = (ValueNodeList)this.getNodeFactory().getNode(15, this.getContextManager());
                ValueNode vn2 = this;
                while (vn2 instanceof OrNode) {
                    OrNode on = vn2;
                    bron = (BinaryRelationalOperatorNode)on.getLeftOperand();
                    if (bron.isInListProbeNode()) {
                        vnl.destructiveAppend(bron.getInListOp().getRightOperandList());
                    } else if (bron.getLeftOperand() instanceof ColumnReference) {
                        vnl.addValueNode(bron.getRightOperand());
                    } else {
                        vnl.addValueNode(bron.getLeftOperand());
                    }
                    vn2 = vn2.getRightOperand();
                }
                InListOperatorNode ilon = (InListOperatorNode)this.getNodeFactory().getNode(55, cr, vnl, this.getContextManager());
                ilon.setType(this.getTypeServices());
                return ilon.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
            }
        }
        return this;
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(underNotNode);
        this.rightOperand = this.rightOperand.eliminateNots(underNotNode);
        if (!underNotNode) {
            return this;
        }
        AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, this.leftOperand, this.rightOperand, this.getContextManager());
        andNode.setType(this.getTypeServices());
        return andNode;
    }

    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        BooleanConstantNode falseNode;
        OrNode curOr = this;
        if (this.rightOperand instanceof AndNode) {
            falseNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(52, this.rightOperand, falseNode, this.getContextManager());
            ((OrNode)this.rightOperand).postBindFixup();
        }
        while (curOr.getRightOperand() instanceof OrNode) {
            curOr = (OrNode)curOr.getRightOperand();
        }
        if (!curOr.getRightOperand().isBooleanFalse()) {
            falseNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
            curOr.setRightOperand((ValueNode)this.getNodeFactory().getNode(52, curOr.getRightOperand(), falseNode, this.getContextManager()));
            ((OrNode)curOr.getRightOperand()).postBindFixup();
        }
        while (this.leftOperand instanceof OrNode) {
            ValueNode newLeft = ((OrNode)this.leftOperand).getLeftOperand();
            OrNode oldLeft = (OrNode)this.leftOperand;
            OrNode newRight = (OrNode)this.leftOperand;
            ValueNode oldRight = this.rightOperand;
            this.leftOperand = newLeft;
            this.rightOperand = newRight;
            newRight.setLeftOperand(oldLeft.getRightOperand());
            newRight.setRightOperand(oldRight);
        }
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    public boolean verifyChangeToCNF() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof OrNode || this.rightOperand.isBooleanFalse();
        if (this.rightOperand instanceof OrNode) {
            isValid = this.rightOperand.verifyChangeToCNF();
        }
        isValid = this.leftOperand instanceof OrNode ? false : this.leftOperand.verifyChangeToCNF();
        return isValid;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }
}

