/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.SpaceInformation;

class AllocationCache {
    private int numExtents = 0;
    private long[] lowRange;
    private long[] hiRange;
    private boolean[] isDirty;
    private AllocExtent[] extents;
    private long[] extentPageNums;
    private boolean isValid = false;

    protected AllocationCache() {
    }

    protected void reset() {
        this.numExtents = 0;
        this.isValid = false;
        if (this.lowRange != null) {
            for (int i = 0; i < this.lowRange.length; ++i) {
                this.lowRange[i] = -1L;
                this.hiRange[i] = -1L;
                this.extentPageNums[i] = -1L;
                this.extents[i] = null;
                this.isDirty[i] = false;
            }
        }
    }

    protected long getAllocPageNumber(BaseContainerHandle handle, long pageNumber, long firstAllocPageNumber) throws StandardException {
        int i;
        for (i = 0; i < this.numExtents; ++i) {
            if (this.lowRange[i] > pageNumber || pageNumber > this.hiRange[i]) continue;
            return this.extentPageNums[i];
        }
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
            for (i = 0; i < this.numExtents; ++i) {
                if (this.lowRange[i] > pageNumber || pageNumber > this.hiRange[i]) continue;
                return this.extentPageNums[i];
            }
        }
        return -1L;
    }

    protected long getLastPageNumber(BaseContainerHandle handle, long firstAllocPageNumber) throws StandardException {
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        return this.hiRange[this.numExtents - 1];
    }

    protected void trackUnfilledPage(long pagenumber, boolean unfilled) {
        if (!this.isValid || this.numExtents <= 0) {
            return;
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.lowRange[i] > pagenumber || pagenumber > this.hiRange[i]) continue;
            AllocExtent ext = this.extents[i];
            if (ext == null || !ext.trackUnfilledPage(pagenumber, unfilled) || this.extents[i] == null) break;
            this.isDirty[i] = true;
            break;
        }
    }

    protected long getUnfilledPageNumber(BaseContainerHandle handle, long firstAllocPageNumber, long pagenum) throws StandardException {
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        if (pagenum == -1L) {
            for (int i = 0; i < this.numExtents; ++i) {
                if (this.extents[i] == null) continue;
                return this.extents[i].getUnfilledPageNumber(pagenum);
            }
        } else {
            for (int i = 0; i < this.numExtents; ++i) {
                if (pagenum > this.hiRange[i] || this.extents[i] == null) continue;
                return this.extents[i].getUnfilledPageNumber(pagenum);
            }
        }
        return -1L;
    }

    protected long getEstimatedPageCount(BaseContainerHandle handle, long firstAllocPageNumber) throws StandardException {
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        long estPageCount = 0L;
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extents[i] == null) continue;
            estPageCount += (long)this.extents[i].getAllocatedPageCount();
        }
        return estPageCount;
    }

    protected SpaceInformation getAllPageCounts(BaseContainerHandle handle, long firstAllocPageNumber) throws StandardException {
        long currAllocPages = 0L;
        long numAllocatedPages = 0L;
        long numFreePages = 0L;
        long numUnfilledPages = 0L;
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extents[i] != null) {
                currAllocPages = this.extents[i].getAllocatedPageCount();
                numAllocatedPages += currAllocPages;
                numUnfilledPages += (long)this.extents[i].getUnfilledPageCount();
                numFreePages += (long)this.extents[i].getTotalPageCount() - currAllocPages;
            }
            SanityManager.ASSERT(numUnfilledPages <= numAllocatedPages, "more unfilled pages than allocated pages on extent[" + i + "], " + "numUnfilledPages = " + numUnfilledPages + ", numAllocatedPages = " + numAllocatedPages + ", numFreePages = " + numFreePages);
        }
        return new SpaceInformation(numAllocatedPages, numFreePages, numUnfilledPages);
    }

    protected void invalidate() {
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "alloc cache invalidated");
        }
        for (int i = 0; i < this.numExtents; ++i) {
            this.isDirty[i] = false;
            this.extents[i] = null;
        }
        this.isValid = false;
    }

    protected void invalidate(AllocPage allocPage, long allocPagenum) throws StandardException {
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "alloc cache for page " + allocPagenum + " invalidated");
        }
        this.isValid = false;
        if (this.numExtents == 0) {
            return;
        }
        for (int i = 0; i < this.numExtents; ++i) {
            if (this.extentPageNums[i] != allocPagenum) continue;
            if (allocPage != null && this.extents[i] != null && this.isDirty[i]) {
                allocPage.updateUnfilledPageInfo(this.extents[i]);
                this.isDirty[i] = false;
            }
            this.extents[i] = null;
            return;
        }
        if (allocPagenum > this.hiRange[this.numExtents - 1]) {
            return;
        }
        SanityManager.THROWASSERT("cannot find extent managed by " + allocPagenum);
    }

    protected void invalidateLastExtent() {
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "last extent (" + this.extentPageNums[this.numExtents - 1] + ") invalidated");
        }
        this.isValid = false;
        if (this.numExtents > 0) {
            this.extents[this.numExtents - 1] = null;
        }
    }

    protected long getLastValidPage(BaseContainerHandle handle, long firstAllocPageNumber) throws StandardException {
        AllocExtent extent = null;
        long lastValidPageNumber = -1L;
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        for (int extentNumber = this.numExtents - 1; extentNumber >= 0 && (lastValidPageNumber = (extent = this.extents[extentNumber]).getLastValidPageNumber()) == -1L; --extentNumber) {
        }
        return lastValidPageNumber;
    }

    protected long getNextValidPage(BaseContainerHandle handle, long pageNumber, long firstAllocPageNumber) throws StandardException {
        int extentNumber;
        if (!this.isValid) {
            this.validate(handle, firstAllocPageNumber);
        }
        if (this.numExtents == 0) {
            return -1L;
        }
        AllocExtent extent = null;
        for (extentNumber = 0; extentNumber < this.numExtents; ++extentNumber) {
            if (pageNumber >= this.hiRange[extentNumber]) continue;
            extent = this.extents[extentNumber];
            break;
        }
        if (extent == null) {
            return -1L;
        }
        SanityManager.ASSERT(extent == this.extents[extentNumber]);
        long nextValidPage = -1L;
        while (extentNumber < this.numExtents && (nextValidPage = (extent = this.extents[extentNumber]).getNextValidPageNumber(pageNumber)) == -1L) {
            ++extentNumber;
        }
        return nextValidPage;
    }

    protected int getPageStatus(BaseContainerHandle handle, long pageNumber, long firstAllocPageNumber) throws StandardException {
        int i;
        AllocExtent extent = null;
        for (i = 0; i < this.numExtents; ++i) {
            if (this.lowRange[i] > pageNumber || pageNumber > this.hiRange[i]) continue;
            extent = this.extents[i];
            break;
        }
        if (extent == null) {
            if (this.isValid) {
                SanityManager.DEBUG_PRINT("trace", "Allocation cache is " + (this.isValid ? "Valid" : "Invalid"));
                for (i = 0; i < this.numExtents; ++i) {
                    SanityManager.DEBUG_PRINT("trace", "Extent " + i + " at " + this.extentPageNums[i] + " range is " + this.lowRange[i] + " to " + this.hiRange[i]);
                    if (this.extents[i] == null) {
                        SanityManager.DEBUG_PRINT("trace", "extent is null");
                        continue;
                    }
                    SanityManager.DEBUG_PRINT("trace", this.extents[i].toDebugString());
                }
                SanityManager.THROWASSERT("valid cache cannot find page " + pageNumber);
            }
            if (!this.isValid) {
                this.validate(handle, firstAllocPageNumber);
            }
            for (i = 0; i < this.numExtents; ++i) {
                if (this.lowRange[i] > pageNumber || pageNumber > this.hiRange[i]) continue;
                extent = this.extents[i];
                break;
            }
            if (extent == null) {
                SanityManager.THROWASSERT("valid cache cannot find page " + pageNumber);
            }
        }
        return extent.getPageStatus(pageNumber);
    }

    private void validate(BaseContainerHandle handle, long firstAllocPageNumber) throws StandardException {
        if (this.numExtents == 0) {
            long pagenum = firstAllocPageNumber;
            while (!this.isValid) {
                this.growArrays(++this.numExtents);
                Page obj = handle.getAllocPage(pagenum);
                if (obj == null) {
                    SanityManager.THROWASSERT("cannot find " + this.numExtents + " alloc page at " + pagenum);
                }
                if (!(obj instanceof AllocPage)) {
                    SanityManager.THROWASSERT("page at " + pagenum + " is not an allocPage, is a " + obj.getClass().getName());
                }
                AllocPage allocPage = (AllocPage)obj;
                this.setArrays(this.numExtents - 1, allocPage);
                if (allocPage.isLast()) {
                    this.isValid = true;
                } else {
                    pagenum = allocPage.getNextAllocPageNumber();
                }
                allocPage.unlatch();
            }
        } else {
            for (int i = 0; i < this.numExtents - 1; ++i) {
                if (this.extents[i] != null) continue;
                AllocPage allocPage = (AllocPage)handle.getAllocPage(this.extentPageNums[i]);
                this.setArrays(i, allocPage);
                if (i < this.numExtents - 1 && this.extentPageNums[i + 1] != allocPage.getNextAllocPageNumber()) {
                    SanityManager.THROWASSERT("bad alloc page - ;extentPageNums[i+1] = " + this.extentPageNums[i + 1] + ";allocPage.getNextAllocPageNumber() = " + allocPage.getNextAllocPageNumber());
                }
                allocPage.unlatch();
            }
            long pagenum = this.extentPageNums[this.numExtents - 1];
            while (!this.isValid) {
                AllocPage allocPage = (AllocPage)handle.getAllocPage(pagenum);
                if (this.extents[this.numExtents - 1] == null) {
                    this.setArrays(this.numExtents - 1, allocPage);
                }
                if (!allocPage.isLast()) {
                    this.growArrays(++this.numExtents);
                    pagenum = allocPage.getNextAllocPageNumber();
                } else {
                    this.isValid = true;
                }
                allocPage.unlatch();
            }
        }
    }

    private void setArrays(int i, AllocPage allocPage) {
        AllocExtent extent;
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "Alloc page " + i + " at " + allocPage.getPageNumber() + " updated");
        }
        this.extents[i] = extent = allocPage.getAllocExtent();
        this.lowRange[i] = extent.getFirstPagenum();
        this.hiRange[i] = extent.getLastPagenum();
        this.extentPageNums[i] = allocPage.getPageNumber();
    }

    private void growArrays(int size) {
        int oldLength = this.lowRange == null || this.lowRange.length == 0 ? 0 : this.lowRange.length;
        if (oldLength >= size) {
            return;
        }
        long[] saveLow = this.lowRange;
        long[] saveHi = this.hiRange;
        AllocExtent[] saveExtents = this.extents;
        boolean[] saveDirty = this.isDirty;
        long[] savePageNums = this.extentPageNums;
        this.lowRange = new long[size];
        this.hiRange = new long[size];
        this.isDirty = new boolean[size];
        this.extents = new AllocExtent[size];
        this.extentPageNums = new long[size];
        if (oldLength > 0) {
            SanityManager.ASSERT(oldLength == saveHi.length);
            SanityManager.ASSERT(oldLength == saveExtents.length);
            SanityManager.ASSERT(oldLength == savePageNums.length);
            System.arraycopy(saveLow, 0, this.lowRange, 0, saveLow.length);
            System.arraycopy(saveHi, 0, this.hiRange, 0, saveHi.length);
            System.arraycopy(saveDirty, 0, this.isDirty, 0, saveDirty.length);
            System.arraycopy(saveExtents, 0, this.extents, 0, saveExtents.length);
            System.arraycopy(savePageNums, 0, this.extentPageNums, 0, savePageNums.length);
        }
        for (int i = oldLength; i < size; ++i) {
            this.lowRange[i] = -1L;
            this.hiRange[i] = -1L;
            this.isDirty[i] = false;
            this.extentPageNums[i] = -1L;
            this.extents[i] = null;
        }
    }

    protected void dumpAllocationCache() {
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "Allocation cache is " + (this.isValid ? "Valid" : "Invalid"));
            for (int i = 0; i < this.numExtents; ++i) {
                SanityManager.DEBUG(FileContainer.SPACE_TRACE, "Extent " + i + " at " + this.extentPageNums[i] + " range is " + this.lowRange[i] + " to " + this.hiRange[i]);
                if (this.extents[i] == null) {
                    SanityManager.DEBUG(FileContainer.SPACE_TRACE, "extent is null");
                    continue;
                }
                SanityManager.DEBUG(FileContainer.SPACE_TRACE, this.extents[i].toDebugString());
            }
        }
    }
}

