/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;

public class BeginXact
implements Loggable {
    protected int transactionStatus;
    protected GlobalTransactionId xactId;

    public BeginXact(GlobalTransactionId xid, int s) {
        this.xactId = xid;
        this.transactionStatus = s;
    }

    public BeginXact() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.transactionStatus);
        out.writeObject(this.xactId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.transactionStatus = in.readInt();
        this.xactId = (GlobalTransactionId)in.readObject();
    }

    public int getTypeFormatId() {
        return 169;
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) {
        RawTransaction rt = (RawTransaction)xact;
        if (instant != null) {
            rt.setFirstLogInstant(instant);
            rt.addUpdateTransaction(this.transactionStatus);
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction xact) {
        return true;
    }

    public void releaseResource(Transaction xact) {
    }

    public int group() {
        int group = 257;
        return group;
    }

    public String toString() {
        return "BeginXact " + this.xactId + " transactionStatus " + Integer.toHexString(this.transactionStatus);
    }

    public GlobalTransactionId getGlobalId() {
        return this.xactId;
    }
}

