/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.reference.Attribute;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.AttributeHolder;

public class URLCheck {
    public Vector attributes;
    public static Vector booleanAttributes;
    LocalizedResource langUtil = LocalizedResource.getInstance();
    Vector validProps;
    private static Vector validDerbyProps;

    public URLCheck(String anURL) {
        try {
            Properties props = this.getAttributes(anURL, new Properties());
            this.check();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            URLCheck uRLCheck = new URLCheck(args[0]);
        }
    }

    public void check() {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            AttributeHolder anAttribute = (AttributeHolder)e.nextElement();
            this.checkForDuplicate(anAttribute);
            anAttribute.check(this.validProps);
        }
    }

    public void checkForDuplicate(AttributeHolder anAttribute) {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            AttributeHolder aHolder = (AttributeHolder)e.nextElement();
            if (anAttribute == aHolder || !anAttribute.getName().equals(aHolder.getName())) continue;
            anAttribute.addError(this.langUtil.getTextMessage("TL_dupAtt"));
        }
    }

    public Properties getAttributes(String url, Properties props) throws Exception {
        String protocol = "";
        if (url.startsWith("jdbc:derby:net:") || url.startsWith("jdbc:derby://")) {
            this.validProps = null;
        } else if (url.startsWith("jdbc:derby:")) {
            protocol = "jdbc:derby:";
            this.validProps = this.getValidDerbyProps();
        } else {
            this.validProps = null;
        }
        StringTokenizer st = new StringTokenizer(url.substring(protocol.length()), ";:\"");
        this.attributes = new Vector();
        while (st.hasMoreTokens()) {
            AttributeHolder anAttribute = new AttributeHolder();
            String anAtt = "";
            String aValue = "";
            String aToken = st.nextToken();
            int eqPos = aToken.indexOf(61);
            if (eqPos == -1) continue;
            anAtt = aToken.substring(0, eqPos).trim();
            aValue = aToken.substring(eqPos + 1).trim();
            anAttribute.setName(anAtt);
            anAttribute.setValue(aValue);
            anAttribute.setToken(aToken);
            this.attributes.addElement(anAttribute);
            props.put(anAtt, aToken);
        }
        return props;
    }

    public static Vector getBooleanAttributes() {
        if (booleanAttributes == null) {
            booleanAttributes = new Vector();
            booleanAttributes.addElement("dataEncryption");
            booleanAttributes.addElement("create");
            booleanAttributes.addElement("shutdown");
            booleanAttributes.addElement("upgrade");
        }
        return booleanAttributes;
    }

    private Vector getValidDerbyProps() {
        if (validDerbyProps == null) {
            try {
                Vector<Object> props = new Vector<Object>();
                Class att = Attribute.class;
                Field[] fields = att.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field aField = fields[i];
                    props.addElement(aField.get(att));
                }
                validDerbyProps = props;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return validDerbyProps;
    }
}

