/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;
import org.apache.derby.jdbc.ReferenceableDataSource;

public class EmbeddedDataSource
extends ReferenceableDataSource
implements DataSource {
    private static final long serialVersionUID = -4945135214995641181L;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private boolean attributesAsPassword;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    transient InternalDriver driver;
    private transient String jdbcurl;

    public boolean equals(Object p0) {
        if (p0 instanceof EmbeddedDataSource) {
            EmbeddedDataSource ds = (EmbeddedDataSource)p0;
            boolean match = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(ds.databaseName)) {
                    match = false;
                }
            } else if (ds.databaseName != null) {
                match = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(ds.dataSourceName)) {
                    match = false;
                }
            } else if (ds.dataSourceName != null) {
                match = false;
            }
            if (this.description != null) {
                if (!this.description.equals(ds.description)) {
                    match = false;
                }
            } else if (ds.description != null) {
                match = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(ds.createDatabase)) {
                    match = false;
                }
            } else if (ds.createDatabase != null) {
                match = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(ds.shutdownDatabase)) {
                    match = false;
                }
            } else if (ds.shutdownDatabase != null) {
                match = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(ds.connectionAttributes)) {
                    match = false;
                }
            } else if (ds.connectionAttributes != null) {
                match = false;
            }
            if (this.loginTimeout != ds.loginTimeout) {
                match = false;
            }
            return match;
        }
        return false;
    }

    public final void setCreateDatabase(String create) {
        this.createDatabase = create != null && create.toLowerCase(Locale.ENGLISH).equals("create") ? create : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String shutdown) {
        this.shutdownDatabase = shutdown != null && shutdown.equalsIgnoreCase("shutdown") ? shutdown : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String prop) {
        this.connectionAttributes = prop;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public final void setAttributesAsPassword(boolean attributesAsPassword) {
        this.attributesAsPassword = attributesAsPassword;
        this.update();
    }

    public final boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(username, password, true);
    }

    final Connection getConnection(String username, String password, boolean requestPassword) throws SQLException {
        Connection conn;
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (!(requestPassword && this.attributesAsPassword || password == null)) {
            info.put("password", password);
        }
        if (this.createDatabase != null) {
            info.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            info.put("shutdown", "true");
        }
        String url = this.jdbcurl;
        if (this.attributesAsPassword && requestPassword && password != null) {
            StringBuffer sb = new StringBuffer(url.length() + password.length() + 1);
            sb.append(url);
            sb.append(';');
            sb.append(password);
            url = sb.toString();
        }
        if ((conn = this.findDriver().connect(url, info)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String url = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(url)) {
            EmbeddedDataSource embeddedDataSource = this;
            synchronized (embeddedDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(url)) {
                    new EmbeddedDriver();
                    AutoloadedDriver autoloadedDriver = (AutoloadedDriver)DriverManager.getDriver(url);
                    this.driver = (InternalDriver)((Object)autoloadedDriver.getDriverModule());
                }
            }
        }
        return this.driver;
    }

    void update() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("jdbc:derby:");
        String dbName = this.getDatabaseName();
        if (dbName != null) {
            dbName = dbName.trim();
        }
        if (dbName == null || dbName.length() == 0) {
            dbName = " ";
        }
        sb.append(dbName);
        String connAttrs = this.getConnectionAttributes();
        if (connAttrs != null && (connAttrs = connAttrs.trim()).length() != 0) {
            sb.append(';');
            sb.append(this.connectionAttributes);
        }
        this.jdbcurl = sb.toString();
    }
}

