/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim;

public class Version implements Comparable<Version> {
	final protected String part[];
	
	public Version(String version) {
		part = version.split("\\.");
	}
	
	@Override
	public String toString() {
		StringBuilder s = new StringBuilder();
		if (part.length > 0) {
			int i = 0;
			s.append(part[i++]);
			for (; i<part.length; i++) {
				s.append(".").append(part[i]);
			}
		}
		return s.toString();
	}
	
	public int compareTo(Version v) {
		if (v == null) throw new IllegalArgumentException();
		int ia = part.length;
		int ib = v.part.length;
		int limit = Math.min(ia, ib);
		for (int i=0; i<limit; i++) {
			String a = part[i];
			String b = v.part[i];
			int c = compare(a, b);
			if (c == 0) continue;
			return c;
		}
		if (ia > ib) return 1;
		if (ia < ib) return -1;
		return 0;
	}
	
	private int compare(String a, String b) {
		try {
			Float af = Float.valueOf(a);
			Float bf = Float.valueOf(b);
			return af.compareTo(bf);
		} catch (NumberFormatException e) {
			return a.compareTo(b);
		}
	}
}
