/***********************************************************************
 * Copyright (c) 2009 CA, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 *     SAS Institute, Inc. - Bug 275731
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import java.io.File;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class DirectoryHandler implements IResourceHandler {
	static final QName DIR = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_Directory");
	static final QName DIR_NAME = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_Directory.Name");
	static final QName DIR_Writable = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_Directory.Writable");

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			CapacityConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConsumptionConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			PropertyConstraintType constraint) {
		if (DIR_Writable.equals(constraint.getPropertyName())) {
			return (Boolean)getPropertyValue(ctxt, rsrc, DIR_Writable);
		}
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			ConditionalPropertyConstraintType constraint) {
		return false;
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			VersionConstraintType constraint) {
		return false;
	}

	public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc,
			QName qname) {
		if (DIR.equals(rsrc.getType())) {
			if (DIR_Writable.equals(qname)) {
				List<PropertyType> l = rsrc.getProperty();
				for(PropertyType property : l) {
					if(property.getPropertyName().equals(DIR_NAME)) {
						return isWritable(ctxt.substituteVariables(property.getValue()));
					}
				}
			}
		}
		return null;
	}

	public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
		return null;
	}

	private Boolean isWritable(String path) {
		File dir = new File(path);
		dir.mkdirs();
		
		return dir.canWrite();
	}

	public boolean evaluate(SDDContext ctxt, ResourceType rsrc,
			RequirementResourceConstraintType constraint) {
		
		boolean result = true;
		for (Object o : constraint.getResourceConstraintGroup()) {
			if (o instanceof JAXBElement<?>) {
				Object value = ((JAXBElement<?>)o).getValue();
				if (value instanceof PropertyConstraintType) {
					result = result && evaluate(ctxt, rsrc, (PropertyConstraintType)value);
					continue;
				}
				if (value instanceof ConsumptionConstraintType) {
					result = result && evaluate(ctxt, rsrc, (ConsumptionConstraintType)value);
					continue;
				}
				if (value instanceof VersionConstraintType) {
					result = result && evaluate(ctxt, rsrc, (VersionConstraintType)value);
				}
			}
		}
		
		return result;
	}

}
