/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IPropertyValueOperators;


public class PropertyValueOperators implements IPropertyValueOperators 
{
	private boolean 
		equal, less, lessOrEqual,					
		greater, greaterOrEqual, contains,
		like, isNull;


	/**
	 * @return the equal
	 */
	public boolean isEqual()
	{
		return equal;
	}
	
	
	/**
	 * @param equal the equal to set
	 */
	public void setEqual(boolean equal)
	{
		this.equal = equal;
	}
	
	
	/**
	 * @return the less
	 */
	public boolean isLess()
	{
		return less;
	}
	
	
	/**
	 * @param less the less to set
	 */
	public void setLess(boolean less)
	{
		this.less = less;
	}
	
	
	/**
	 * @return the lessOrEqual
	 */
	public boolean isLessOrEqual()
	{
		return lessOrEqual;
	}
	
	
	/**
	 * @param lessOrEqual the lessOrEqual to set
	 */
	public void setLessOrEqual(boolean lessOrEqual)
	{
		this.lessOrEqual = lessOrEqual;
	}
	
	
	/**
	 * @return the greater
	 */
	public boolean isGreater()
	{
		return greater;
	}
	
	
	/**
	 * @param greater the greater to set
	 */
	public void setGreater(boolean greater)
	{
		this.greater = greater;
	}
	
	
	/**
	 * @return the greaterOrEqual
	 */
	public boolean isGreaterOrEqual()
	{
		return greaterOrEqual;
	}
	
	
	/**
	 * @param greaterOrEqual the greaterOrEqual to set
	 */
	public void setGreaterOrEqual(boolean greaterOrEqual)
	{
		this.greaterOrEqual = greaterOrEqual;
	}
	
	
	/**
	 * @return the contains
	 */
	public boolean isContains()
	{
		return contains;
	}
	
	
	/**
	 * @param contains the contains to set
	 */
	public void setContains(boolean contains)
	{
		this.contains = contains;
	}
	
	
	/**
	 * @return the like
	 */
	public boolean isLike()
	{
		return like;
	}
	
	
	/**
	 * @param like the like to set
	 */
	public void setLike(boolean like)
	{
		this.like = like;
	}
	
	
	/**
	 * @return the isNull
	 */
	public boolean isNull()
	{
		return isNull;
	}
	
	
	/**
	 * @param isNull the isNull to set
	 */
	public void setNull(boolean isNull)
	{
		this.isNull = isNull;
	}
	
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.PROPERTYVALUEOPERATORS_ELEMENT, false));
		
		boolean[] flagArray = new boolean[]{
				equal, less, lessOrEqual,					
				greater, greaterOrEqual, contains,
				like, isNull};
		
		String[] attributeNames = new String[]{
				ServiceMetadataConstants.EQUAL_ATTRIBUTE,
				ServiceMetadataConstants.LESS_ATTRIBUTE,
				ServiceMetadataConstants.LESSOREQUAL_ATTRIBUTE,
				ServiceMetadataConstants.GREATER_ATTRIBUTE,
				ServiceMetadataConstants.GREATEROREQUAL_ATTRIBUTE,
				ServiceMetadataConstants.CONTAINS_ATTRIBUTE,
				ServiceMetadataConstants.LIKE_ATTRIBUTE,				
				ServiceMetadataConstants.ISNULL_ATTRIBUTE				
		};
		
		for (int i = 0; i < attributeNames.length; i++)
		{
			writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
			CMDBfServicesUtil.writeAttribute(writer, attributeNames[i], String.valueOf(flagArray[i]));
		}
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
	}
	
	
	public boolean equals(Object obj) 
	{
		if (this == obj)
			return true;
		
		if (obj == null || getClass() != obj.getClass())
			return false;
				
		final PropertyValueOperators other = (PropertyValueOperators) obj;
		return 	equal == other.equal &&  
				less == other.less &&
				lessOrEqual == other.lessOrEqual &&
				greater == other.greater &&
				greaterOrEqual == other.greaterOrEqual &&
				contains == other.contains &&
				like == other.like &&
				isNull == other.isNull;
	}	
}
