/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <queryCapabilities> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IQueryCapabilities extends IXMLWritable
{
	
	/**
	 * set the relationshipTemplateSupport in the queryCapabilities
	 * 
	 * @param relationshipTemplateSupport
	 */
	public void setRelationshipTemplateSupport(IRelationshipTemplateSupport relationshipTemplateSupport);
		
	/**
	 * Retrieve the relationshipTemplateSupport
	 * 
	 * @return IRelationshipTemplateSupport
	 */
	public IRelationshipTemplateSupport getRelationshipTemplateSupport();
	
	
	/**
	 * set the contentSelectorSupport in the queryCapabilities
	 * 
	 * @param contentSelectorSupport
	 */
	public void setContentSelectorSupport(IContentSelectorSupport contentSelectorSupport);
		
	/**
	 * Retrieve the contentSelectorSupport
	 * 
	 * @return IContentSelectorSupport
	 */
	public IContentSelectorSupport getContentSelectorSupport();
	
	
	/**
	 * set the recordConstraintSupport in the queryCapabilities
	 * 
	 * @param recordConstraintSupport
	 */
	public void setRecordConstraintSupport(IRecordConstraintSupport recordConstraintSupport);
		
	/**
	 * Retrieve the recordConstraintSupport
	 * 
	 * @return IRecordConstraintSupport
	 */
	public IRecordConstraintSupport getRecordConstraintSupport();
	
	
	/**
	 * set the xpathSupport in the queryCapabilities
	 * 
	 * @param xpathSupport
	 */
	public void setXpathSupport(IXpathSupport xpathSupport);
		
	/**
	 * Retrieve the xpathSupport
	 * 
	 * @return IXpathSupport
	 */
	public IXpathSupport getXpathSupport();

	
}
