/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.OutputterFactoryImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.RequestParametersImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionOutputterContextImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionResolveFixedTreeIDs;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractServletHandler;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IIDResolver;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterFactory;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterParameters;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * Exception performing whole class analysis ignored.
 */
public class OutputterDelegator
extends AbstractServletHandler {
    static final long serialVersionUID = -5991590204597891023L;
    private static ILogger logger = LoggerWrapper.getLogger(OutputterDelegator.class);

    public void doGet(HttpServletRequest req, StringWriter resp) throws ServletException, IOException {
        this.delegateRequest(req, resp);
    }

    protected IIDResolver getIDResolver(HttpServletRequest request) {
        SessionResolveFixedTreeIDs idResolver = new SessionResolveFixedTreeIDs(request.getSession());
        idResolver.clear();
        return idResolver;
    }

    public void doPost(HttpServletRequest req, StringWriter resp) throws ServletException, IOException {
        this.delegateRequest(req, resp);
    }

    protected IOutputterContext createOutputterContext(HttpServletRequest req) {
        return new SessionOutputterContextImpl(req);
    }

    protected void delegateRequest(HttpServletRequest req, StringWriter resp) throws ServletException, IOException {
        try {
            String service = req.getParameter("service");
            RequestParametersImpl parameters = new RequestParametersImpl(req);
            IOutputter outputter = this.createOutputter(service, req.getSession());
            List invalidParam = outputter.getInvalidInput((IParameters)parameters);
            if (invalidParam.size() == 0) {
                outputter.setIdResolver(this.getIDResolver(req));
                IOutputterContext context = this.createOutputterContext(req);
                outputter.initalize(context, (IParameters)parameters);
                outputter.render(new PrintWriter(resp), (IParameters)parameters);
            } else {
                String nullParameters = "";
                for (int x = 0; x < invalidParam.size(); ++x) {
                    nullParameters = nullParameters + ((IOutputterParameters)invalidParam.get(x)).getName() + " ";
                }
                this.sendError(new Exception(MessageFormat.format(Messages.getString((String)"URLDelegator.PARAM_REQUIRED_ERR"), nullParameters)), resp);
            }
        }
        catch (Exception e) {
            try {
                this.sendError(e, resp);
                req.getSession().getServletContext().log(e.getMessage(), (Throwable)e);
            }
            catch (Exception exc) {
                throw new ServletException((Throwable)exc);
            }
        }
    }

    protected static String HTMLEntityEncode(String s) throws Exception {
        if (s == null) {
            return "";
        }
        return URLEncoder.encode(s, "UTF-8");
    }

    protected void sendError(Exception e, StringWriter resp) throws Exception {
        resp.append("{_error_:true, message:'" + OutputterDelegator.HTMLEntityEncode((String)e.getLocalizedMessage()) + "', detail:'");
        StringWriter sw = new StringWriter();
        PrintWriter pwExc = new PrintWriter(sw);
        logger.error((Object)e);
        e.printStackTrace(pwExc);
        pwExc.flush();
        resp.append(OutputterDelegator.HTMLEntityEncode((String)sw.getBuffer().toString()));
        resp.append("'}");
        pwExc.close();
        sw.close();
    }

    protected IOutputter createOutputter(String id, HttpSession session) throws Exception {
        IOutputterFactory factory = (IOutputterFactory)session.getAttribute("OUTPUTTER_FACTORY");
        if (factory == null) {
            factory = new OutputterFactoryImpl();
            session.setAttribute("OUTPUTTER_FACTORY", (Object)factory);
        }
        return factory.createOutputter(id);
    }
}

